/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.SpanPanel;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.like.presentation.client.ui.LikeView;
import de.justsoftware.onx.like.presentation.client.ui.LikeViewLink;
import de.justsoftware.onx.like.shared.model.LikeStatus;
import javax.annotation.Nonnull;

public class LikeViewLink
extends Composite
implements LikeView {
    private final FlowPanel _content = new FlowPanel();
    private LikeView.Presenter _presenter;
    private final LikeViewStyle _viewStyle;
    private final ClickHandler _likeClickHandler = new /* Unavailable Anonymous Inner Class!! */;

    @UiConstructor
    public LikeViewLink(@Nonnull LikeViewStyle viewStyle) {
        this.initWidget((Widget)this._content);
        this._viewStyle = viewStyle;
        this._content.addStyleName("inlinePanel");
        this._content.addStyleName("like-view-link");
    }

    public void setPresenter(LikeView.Presenter presenter) {
        this._presenter = presenter;
    }

    public void setLikeStatus(LikeStatus likeStatus) {
        this._content.clear();
        if (likeStatus == null || !likeStatus.mayLikeOrUnlike()) {
            this._content.setVisible(false);
            return;
        }
        this._content.setVisible(true);
        this._content.add((Widget)this.createLikePanel(likeStatus));
        if (likeStatus.getLikeCount() > 0) {
            this._content.add((Widget)this.createCountPanel(likeStatus));
        }
    }

    @Nonnull
    private SpanPanel createCountPanel(@Nonnull LikeStatus likeStatus) {
        SpanPanel countContainer = new SpanPanel();
        switch (3.$SwitchMap$de$justsoftware$onx$like$presentation$client$ui$LikeViewLink$LikeViewStyle[this._viewStyle.ordinal()]) {
            case 1: {
                countContainer.addStyleName("like-count-container-long");
                break;
            }
            case 2: {
                countContainer.addStyleName("like-count-container-short");
            }
        }
        String likeText = this._viewStyle == LikeViewStyle.LONG ? I18nMediator.LIKE.xLikes(likeStatus.getLikeCount()) : String.valueOf(likeStatus.getLikeCount());
        Anchor countAnchor = new Anchor(true);
        countAnchor.setText(likeText);
        countContainer.add((Widget)countAnchor);
        2 countClickHandler = new /* Unavailable Anonymous Inner Class!! */;
        countAnchor.addClickHandler((ClickHandler)countClickHandler);
        return countContainer;
    }

    @Nonnull
    private SpanPanel createLikePanel(@Nonnull LikeStatus likeStatus) {
        String text = likeStatus.isDoILike() ? I18nMediator.LIKE.unlikeNoCount() : I18nMediator.LIKE.likeNoCount();
        SpanPanel likeContainer = new SpanPanel();
        IconType icon = likeStatus.isDoILike() ? IconType.HEART : IconType.HEART_EMPTY;
        JCIconOnlyAnchor iconAnchor = new JCIconOnlyAnchor(icon, this._likeClickHandler);
        iconAnchor.setIconSize(IconSize.LARGE);
        iconAnchor.addStyleName("app-hover-color");
        likeContainer.add((Widget)iconAnchor);
        if (this._viewStyle != LikeViewStyle.SHORT) {
            Anchor anchor = new Anchor(true);
            anchor.setText(text);
            anchor.addClickHandler(this._likeClickHandler);
            likeContainer.add((Widget)anchor);
        }
        return likeContainer;
    }

    public void showWaitIcon() {
    }

    protected void onLoad() {
        super.onLoad();
        if (this._presenter != null) {
            this._presenter.onLoad();
        }
    }

    protected void onUnload() {
        super.onUnload();
        if (this._presenter != null) {
            this._presenter.onUnload();
        }
    }
}

