/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.version;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasOneWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.pager.PagerHandler;
import de.justsoftware.onx.common.presentation.client.pager.PagerPresenter;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionCompareResultInfoPresenter;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionCompareRowPresenter;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionCompareView;
import de.justsoftware.onx.container.presentation.shared.EntityVersionControllerAsync;
import de.justsoftware.onx.container.shared.model.EntityId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityVersionComparePresenter
implements EntityVersionCompareView.Presenter,
PagerHandler {
    private static final int NUMBER_OF_VERSIONS = 10;
    private final ClientFactory _clientFactory;
    private final EntityVersionCompareView _view;
    private final EntityVersionControllerAsync _controller;
    private final EntityVersionCompareResultInfoPresenter _resultInfoPresenter;
    private ImmutableList<EntityVersionCompareRowPresenter> _rowPresenter = ImmutableList.of();
    private EntityId _entityId = null;
    private EntityVersionClientModel _firstVersion = null;
    private EntityVersionClientModel _secondVersion = null;
    private final PagerPresenter _pager;

    public EntityVersionComparePresenter(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._controller = this._clientFactory.entityVersionFactory().controller();
        this._view = this._clientFactory.entityVersionFactory().entityVersionCompareView();
        this._resultInfoPresenter = new EntityVersionCompareResultInfoPresenter(this._clientFactory);
        this._view.setResultInfoPanelVisible(false);
        this._view.setCompareOptionsVisible(false);
        this._pager = new PagerPresenter(this._clientFactory, (PagerHandler)this);
    }

    public void show(EntityId entityId, HasOneWidget widget) {
        this._entityId = entityId;
        this.updateCompareButton();
        this._view.show(widget, (EntityVersionCompareView.Presenter)this);
        this.loadVersions(0);
    }

    private void loadVersions(int page) {
        this._controller.getVersionDetails(this._entityId, 10, page * 10, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setFirstVersion(EntityVersionClientModel firstVersion) {
        this._firstVersion = firstVersion;
        UnmodifiableIterator unmodifiableIterator = this._rowPresenter.iterator();
        while (unmodifiableIterator.hasNext()) {
            EntityVersionCompareRowPresenter row;
            row.setSelectionAsSecondVersionPossible((row = (EntityVersionCompareRowPresenter)unmodifiableIterator.next()).getVersion().getId().getId() != firstVersion.getId().getId());
        }
        this.updateCompareButton();
    }

    public void setSecondVersion(EntityVersionClientModel secondVersion) {
        this._secondVersion = secondVersion;
        UnmodifiableIterator unmodifiableIterator = this._rowPresenter.iterator();
        while (unmodifiableIterator.hasNext()) {
            EntityVersionCompareRowPresenter row;
            row.setSelectionAsFirstVersionPossible((row = (EntityVersionCompareRowPresenter)unmodifiableIterator.next()).getVersion().getId().getId() != secondVersion.getId().getId());
        }
        this.updateCompareButton();
    }

    public void updateCompareButton() {
        this._view.setCompareButtonEnabled(this._firstVersion != null && this._secondVersion != null);
    }

    public void compare() {
        if (this._firstVersion != null && this._secondVersion != null) {
            EntityVersionClientModel version1 = this._firstVersion.getId().before(this._secondVersion.getId()) ? this._firstVersion : this._secondVersion;
            EntityVersionClientModel version2 = this._firstVersion.getId().before(this._secondVersion.getId()) ? this._secondVersion : this._firstVersion;
            this._controller.getWikiCompareData(version1.getId(), version2.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateResultInfo(@Nonnull EntityVersionClientModel v1, @Nullable EntityVersionClientModel v2) {
        this._view.setResultInfoPanelVisible(true);
        this._resultInfoPresenter.setVersions(v1, v2);
        this._resultInfoPresenter.show(this._view.getResultInfoContentPanel());
    }

    public void singleVersionSelected(EntityVersionClientModel version) {
        this._view.setCompareOptionsVisible(false);
        this.updateResultInfo(version, null);
        this._controller.getWikiVersionAsHtmlString(version.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void handlePageChange(int newPage) {
        this.loadVersions(newPage);
    }

    public void deleteVersion(EntityVersionClientModel version) {
        this._controller.deleteVersion(version.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void restoreVersion(EntityVersionClientModel version) {
        this._controller.restoreVersion(version.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

