/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.navigator;

import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorBreadcrumbPresenter;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorBreadcrumbView;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorView;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorViewImpl;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterTabsPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterTogglePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchInputView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchPanelView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultWidget;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityNavigatorViewImpl
implements EntityNavigatorView {
    private final FlowPanel _view = new FlowPanel();
    private final ClientFactory _clientFactory;
    private final SearchPanelView _searchPanel;
    private final EntityNavigatorBreadcrumbView.Presenter _breadcrumbPresenter;
    private final SearchInputView.Presenter _searchInputPresenter;
    private final SearchFilterTabsPresenter _searchFilterPresenter;
    private final EntityInfo _entity;
    private SearchResultWidget _searchResultWidget;
    private SearchParameters _searchParameters;

    public EntityNavigatorViewImpl(ClientFactory clientFactory, SearchParameters searchParameters, ImmutableSet<FilterType> filterTypes, EntityInfo entity) {
        this._clientFactory = clientFactory;
        this._entity = entity;
        this._searchParameters = searchParameters;
        this._view.addStyleName("entity-navigator");
        if (this._clientFactory.entityFactory().entityConfig((EntityType)entity.getType()).isNavigatorSearchable()) {
            1 searchFilterToggle = new /* Unavailable Anonymous Inner Class!! */;
            searchFilterToggle.setEnabled(true);
            this._searchInputPresenter = this._clientFactory.searchFactory().createSearchInputPresenter(false, "entity_hierarchy_tab");
            this._searchInputPresenter.update(searchParameters);
            this._searchInputPresenter.setSearchFilterToggle((SearchFilterTogglePresenter)searchFilterToggle);
            this._searchFilterPresenter = new /* Unavailable Anonymous Inner Class!! */;
            this._searchPanel = this._clientFactory.searchFactory().createSearchPanelView();
            this._searchPanel.setSearchInput((IsWidget)this._searchInputPresenter.getView());
            this._searchPanel.setSearchFilter(this._searchFilterPresenter.getView());
        } else {
            this._searchPanel = null;
            this._searchFilterPresenter = null;
            this._searchInputPresenter = null;
        }
        this._searchResultWidget = this._clientFactory.entityFactory().getEntityNavigatorSearchResultWidget(searchParameters, (SearchFilterPresenter)this._searchFilterPresenter, entity);
        this.showSearchFilter(false);
        this._breadcrumbPresenter = new EntityNavigatorBreadcrumbPresenter(clientFactory, searchParameters, entity);
        this.buildView();
    }

    private void buildView() {
        this._view.clear();
        this._view.add((IsWidget)this._breadcrumbPresenter.getView());
        if (this._searchPanel != null) {
            this._view.add(this._searchPanel.asWidget());
        }
        this._view.add((Widget)this._searchResultWidget);
    }

    public Widget asWidget() {
        return this._view;
    }

    public void onSearchParametersChanged(SearchParameters parameters) {
        if (this._searchInputPresenter != null) {
            this._searchInputPresenter.update(parameters);
        }
        if (this._searchFilterPresenter != null) {
            this._searchFilterPresenter.onSearchParametersChanged(parameters);
        }
        if (!parameters.getContextHierarchy().equals((Object)this._searchParameters.getContextHierarchy())) {
            this._searchResultWidget = this._clientFactory.entityFactory().getEntityNavigatorSearchResultWidget(parameters, (SearchFilterPresenter)this._searchFilterPresenter, this._entity);
            this.buildView();
        } else {
            this._searchResultWidget.setSearchParameters(parameters);
        }
        this._breadcrumbPresenter.onSearchParametersChanged(parameters);
        this._searchParameters = parameters;
    }

    public void showSearchFilter(boolean show) {
        if (this._searchPanel != null) {
            this._searchPanel.showSearchFilter(show);
        }
        if (this._searchFilterPresenter != null) {
            this._searchFilterPresenter.showFilterList(show);
        }
    }
}

