/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.CompositePanelWithValue;
import de.justsoftware.onx.common.shared.util.StringUtil;

public class SubdomainTextBox
extends CompositePanelWithValue<String>
implements Validatable {
    public static final String URL_PATTERN = "[A-Za-z0-9]+([.-]?[A-Za-z0-9])*";
    public static final int MINIMUM_URL_LENGTH = 3;
    private final TextBox _subdomain = new TextBox();
    private final InlineLabel _prefix = new InlineLabel();
    private final InlineLabel _suffix = new InlineLabel();
    private boolean _mandatory = false;

    public SubdomainTextBox() {
        this.add((Widget)this._prefix);
        this.add((Widget)this._subdomain);
        this.add((Widget)this._suffix);
    }

    public String getValue() {
        return this._subdomain.getValue();
    }

    protected void setValue(String oldValue, String newValue, boolean fireEvents) {
        this._subdomain.setText(newValue);
        super.setValue((Object)oldValue, (Object)newValue, fireEvents);
    }

    public void validate() throws ValidationException {
        String value = this.getValue();
        if (StringUtil.isBlank((String)value) ? this._mandatory : !this.isValidUrl(value)) {
            throw new ValidationException(I18nMediator.BASIC_CONSTANTS.subdomainMayOnlyContain());
        }
    }

    private boolean isValidUrl(String s) {
        if (s == null || s.length() < 3) {
            return false;
        }
        return s.matches(URL_PATTERN);
    }

    public void setMandatory(boolean mandatory) {
        this._mandatory = mandatory;
    }

    public void setPrefix(String text) {
        this._prefix.setText(text);
    }

    public void setSuffix(String suffix) {
        this._suffix.setText(suffix);
    }
}

