/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.presentation.client.ui.EntityMemberActionCommand;
import de.justsoftware.onx.container.presentation.client.ui.EntityMemberBatchActionCommandSelector;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class EntityMemberBatchActionCommandSelector
implements EntityMemberRole.Visitor<ImmutableSet<EntityMemberActionCommand>> {
    private final ImmutableSet.Builder<EntityMemberActionCommand> _builder = ImmutableSet.builder();
    private final EntityMemberWorkflow _workflow;
    private final ImmutableSet<? extends Action> _allowedActions;
    private final boolean _rolesAreInherited;

    EntityMemberBatchActionCommandSelector(EntityMemberWorkflow workflow, ImmutableSet<? extends Action> allowedActions, boolean rolesAreInherited) {
        this._workflow = workflow;
        this._allowedActions = allowedActions;
        this._rolesAreInherited = rolesAreInherited;
    }

    public ImmutableSet<EntityMemberActionCommand> visitAdmin() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.ASSIGN_MEMBERSHIP);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitCoAdmin() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            switch (1.$SwitchMap$de$justsoftware$onx$container$shared$model$EntityMemberWorkflow[this._workflow.ordinal()]) {
                case 1: {
                    this._builder.add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_PARTICIPANT_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_WAITINGLIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_NOT_ATTENDING_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_UNDECIDED_LIST);
                    break;
                }
                case 2: {
                    this._builder.add((Object)EntityMemberActionCommand.ASSIGN_MEMBERSHIP);
                }
            }
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_DELETE_COADMIN) && !this._rolesAreInherited) {
            this._builder.add((Object)EntityMemberActionCommand.DELETE_COADMIN);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitMember() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.REVOKE_MEMBERSHIP);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitRejected() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.ASSIGN_MEMBERSHIP);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitHasSentJoinRequest() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.ASSIGN_MEMBERSHIP);
            this._builder.add((Object)EntityMemberActionCommand.REVOKE_MEMBERSHIP);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitHasInvitation() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.ASSIGN_MEMBERSHIP);
            if (!this._rolesAreInherited) {
                this._builder.add((Object)EntityMemberActionCommand.REVOKE_MEMBERSHIP);
            }
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitIsUndecided() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_PARTICIPANT_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_WAITINGLIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_NOT_ATTENDING_LIST).add((Object)EntityMemberActionCommand.REMOVE_FROM_EVENT);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitIsNotAttendingTheEvent() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_PARTICIPANT_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_WAITINGLIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_UNDECIDED_LIST).add((Object)EntityMemberActionCommand.REMOVE_FROM_EVENT);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitIsAttendingTheEvent() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_WAITINGLIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_NOT_ATTENDING_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_UNDECIDED_LIST).add((Object)EntityMemberActionCommand.REMOVE_FROM_EVENT);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitIsMaybeAttendingTheEvent() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_PARTICIPANT_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_WAITINGLIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_NOT_ATTENDING_LIST).add((Object)EntityMemberActionCommand.REMOVE_FROM_EVENT);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitIsOnWaitinglistForEvent() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_PARTICIPANT_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_NOT_ATTENDING_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_UNDECIDED_LIST).add((Object)EntityMemberActionCommand.REMOVE_FROM_EVENT);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitIsInvitedToEvent() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_PARTICIPANT_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_WAITINGLIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_NOT_ATTENDING_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_UNDECIDED_LIST);
            if (!this._rolesAreInherited) {
                this._builder.add((Object)EntityMemberActionCommand.REMOVE_FROM_EVENT);
            }
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitHasRejectedTheEventInvitation() {
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._builder.add((Object)EntityMemberActionCommand.MAKE_COADMIN);
        }
        if (this._allowedActions.contains((Object)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            this._builder.add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_PARTICIPANT_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_WAITINGLIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_NOT_ATTENDING_LIST).add((Object)EntityMemberActionCommand.MOVE_TO_EVENT_UNDECIDED_LIST).add((Object)EntityMemberActionCommand.REMOVE_FROM_EVENT);
        }
        return this._builder.build();
    }

    public ImmutableSet<EntityMemberActionCommand> visitDynamicRole(EntityMemberRole dynamicRole) {
        return ImmutableSet.of();
    }
}

