/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.components;

import com.freiheit.toro.client.event.GlobalEventBus;
import com.freiheit.toro.client.event.GlobalEventManager;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.components.InfoWidgetComponentPresenter;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.editor.InlineEditorView;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockHandler;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockOwner;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.presentation.shared.EntityControllerAsync;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.GlobalId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InfoWidgetComponentEditorPresenter
implements InlineEditorView.Presenter {
    private static final int INFO_WIDGET_EDIT_LINK_POS = 0;
    private final InlineEditorView _view;
    private final EntityDetails _entity;
    private final InfoWidgetComponentPresenter _parentPresenter;
    private final EntityControllerAsync _controller;
    private final GlobalEventManager _globalEventManager;
    private final LockHandler _lockHandler;
    private final boolean _editable;

    public InfoWidgetComponentEditorPresenter(EditorClientFactory editorClientFactory, EntityDetails entity, String toolbar, InfoWidgetComponentPresenter parentPresenter, EntityControllerAsync controller, HistoryManager historyManager, GlobalEventManager globalEventManager, EntityConstants i18n) {
        this._entity = entity;
        this._parentPresenter = parentPresenter;
        this._controller = controller;
        this._globalEventManager = globalEventManager;
        this._lockHandler = new LockHandler(editorClientFactory.lockManager(), LockOwner.INFO_COMPONENT);
        this._editable = entity.getMay().contains((Object)StaticEntityAction.ENTITY_MODIFY);
        this._view = editorClientFactory.getInlineEditorView((InlineEditorView.Presenter)this, (GlobalId)entity.getId(), this._editable, true);
        this._view.setContent(entity.getDescription());
        this._view.setToolbar(toolbar);
        this._view.setFilebrowserUploadUrl(UrlUtil.generateCKEditorUploadUrl((GlobalId)this._entity.getId()));
        if (this._editable) {
            this._globalEventManager.fireRenderWikiEditLink(StaticComponentType.INFO_WIDGET.getName(), (GlobalEventBus.Callback)new /* Unavailable Anonymous Inner Class!! */, i18n.editInfoWidget(), 0);
            historyManager.confirmNextHistoryChange((HistoryManager.ConfirmHistoryChangeCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void onEdit(boolean respectLock) {
        this.startEdit(null);
    }

    public void onContentClick(boolean respectLock) {
        this.startEdit(() -> ((InlineEditorView)this._view).focus());
    }

    private void startEdit(Runnable callback) {
        if (this._lockHandler.tryLock()) {
            this._view.startInlineEditing(callback);
            this._view.showButtons(true);
            this._globalEventManager.fireDeactivateWikiEditLink();
        }
    }

    public void onSave(boolean sendNotificationToSubscribers) {
        String updatedDescription = this._view.getContent();
        this._controller.updateEntityDescription(this._entity.getId(), updatedDescription, sendNotificationToSubscribers, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void stopEditing(String description) {
        this._lockHandler.freeLock();
        this._view.setDirty(false);
        this._view.stopInlineEditing(description);
        this._view.setSaveButtonEnabled(false);
        this._view.showButtons(false);
        this._globalEventManager.fireActivateWikiEditLink();
    }

    public void onCancel() {
        this.stopEditing(this._entity.getDescription());
    }

    public void onChange(boolean dirty) {
        this._view.setSaveButtonEnabled(dirty);
        this._view.setDirty(dirty);
    }

    @Nonnull
    public IsWidget getView() {
        return this._view;
    }

    public void onUnload() {
        this._lockHandler.freeLock();
        this._globalEventManager.fireRemoveWikiEditLink(StaticComponentType.INFO_WIDGET.getName());
    }

    public boolean clearOnUnload() {
        return true;
    }

    public boolean resetOnLoad() {
        return true;
    }

    public boolean isEmpty() {
        return !this._editable && !ClientStringUtil.hasText((String)this._view.getContent());
    }
}

