/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.AbstractInPlaceEdit;
import de.justsoftware.onx.common.presentation.client.ui.RichTextEditorWithAlbum;
import de.justsoftware.onx.common.presentation.client.ui.UserGeneratedHtml;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorMessages;
import javax.annotation.Nonnull;

public class InPlaceRichTextEditor
extends AbstractInPlaceEdit<String> {
    private static final WikiEditorMessages WIKI_EDITOR_MSG = I18nMediator.WIKI_EDITOR_MSG;
    private final UserGeneratedHtml _show;
    private final ClientFactory _clientFactory;
    private RichTextEditorWithAlbum _editor = null;
    private final FlowPanel _edit = new FlowPanel();
    private String _editWidth = "300px";
    private String _editHeight = "120px";
    private GlobalId _parentId;
    private boolean _forceText = false;
    private String _forceTextErrorMessage = "";

    public InPlaceRichTextEditor(@Nonnull ClientFactory clientFactory) {
        super((Object)"");
        this._clientFactory = clientFactory;
        this._show = new UserGeneratedHtml(clientFactory.eventManager());
        this._show.addStyleName("clearfix");
        this.setShowWidget((Widget)this._show);
        this.setEditWidget((Widget)this._edit);
    }

    protected String getEditValue() {
        return this._editor == null ? "" : this._editor.getHTML();
    }

    private void createEditor() {
        if (this._editor == null) {
            this._editor = new RichTextEditorWithAlbum(this._parentId, this._editWidth, this._editHeight, this._clientFactory);
            this._edit.add((Widget)this._editor);
        }
    }

    public void clearEditor() {
        this._editor = null;
        this._edit.clear();
    }

    protected String validate(String value) {
        if (this._forceText && StringUtil.isBlank((String)value)) {
            return this._forceTextErrorMessage;
        }
        if (value.length() > 250000) {
            return WIKI_EDITOR_MSG.htmlTooLong(250000);
        }
        return null;
    }

    protected void setEditValue(String value) {
        this.createEditor();
        this._editor.setHTML(value == null ? "" : value);
    }

    public void setShowValue(String value) {
        this._show.setHTML(value);
    }

    protected void setWaitValue(String value) {
    }

    public void setEditWidth(String editWidth) {
        this._editWidth = editWidth;
    }

    public void setEditHeight(String editHeight) {
        this._editHeight = editHeight;
    }

    public void setParentId(GlobalId parentId) {
        this._parentId = parentId;
    }

    public boolean isForceText() {
        return this._forceText;
    }

    public void setForceText(boolean forceText) {
        this._forceText = forceText;
    }

    public String getForceTextErrorMessage() {
        return this._forceTextErrorMessage;
    }

    public void setForceTextErrorMessage(String forceTextErrorMessage) {
        this._forceTextErrorMessage = forceTextErrorMessage;
    }
}

