/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ValueBoxBase;
import de.justsoftware.onx.common.presentation.client.ui.AntiSuggestHandler;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AntiSuggestHandler
implements ChangeHandler,
KeyDownHandler,
KeyUpHandler,
KeyPressHandler,
FocusHandler,
BlurHandler {
    private boolean _active = true;
    private final Map<String, AntiSuggestState> _stateMap = Maps.newHashMap();
    private final ValueBoxBase<?> _field;

    public AntiSuggestHandler(@Nonnull ValueBoxBase<?> field) {
        this(field, (Iterable)ImmutableSet.of((Object)""));
    }

    public AntiSuggestHandler(@Nonnull ValueBoxBase<?> field, @Nonnull Iterable<String> initialWhiteList) {
        this._field = field;
        for (String w : initialWhiteList) {
            this._stateMap.put(this.normalize(w), AntiSuggestState.WHITE);
        }
    }

    public final void onChange(ChangeEvent event) {
        this.onChangeNameField();
    }

    public final void onBlur(BlurEvent event) {
        this.onChangeNameField();
    }

    public final void onFocus(FocusEvent event) {
        this.onChangeNameField();
    }

    public final void onKeyPress(KeyPressEvent event) {
        this.onChangeNameField();
    }

    public final void onKeyUp(KeyUpEvent event) {
        this.onChangeNameField();
    }

    public final void onKeyDown(KeyDownEvent event) {
        this.onChangeNameField();
    }

    private void onChangeNameField() {
        if (this._active) {
            String text = this._field.getText();
            String normalized = this.normalize(text);
            AntiSuggestState state = (AntiSuggestState)this._stateMap.get(normalized);
            if (state != null) {
                switch (3.$SwitchMap$de$justsoftware$onx$common$presentation$client$ui$AntiSuggestHandler$AntiSuggestState[state.ordinal()]) {
                    case 1: {
                        this.showFoundWarning(text);
                        break;
                    }
                    case 2: {
                        this.removeFoundWarning();
                        break;
                    }
                }
            } else {
                this._stateMap.put(normalized, AntiSuggestState.SEARCHED);
                this.search(normalized, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void updateStates(@Nonnull String normalized, @Nullable Iterable<String> result) {
        if (result != null) {
            for (String suggest : result) {
                String normalizedSuggest = this.normalize(suggest);
                if (this._stateMap.get(normalizedSuggest) == AntiSuggestState.WHITE) continue;
                this._stateMap.put(normalizedSuggest, AntiSuggestState.BLACK);
            }
        }
        if (this._stateMap.get(normalized) != AntiSuggestState.BLACK) {
            this._stateMap.put(normalized, AntiSuggestState.WHITE);
        }
    }

    public void check(@Nullable String search, @Nonnull AsyncCallback<Boolean> callback) {
        if (this._active) {
            String normalized = this.normalize(search);
            AntiSuggestState state = (AntiSuggestState)this._stateMap.get(normalized);
            if (state != null) {
                switch (3.$SwitchMap$de$justsoftware$onx$common$presentation$client$ui$AntiSuggestHandler$AntiSuggestState[state.ordinal()]) {
                    case 1: {
                        callback.onSuccess((Object)Boolean.FALSE);
                        return;
                    }
                    case 2: {
                        callback.onSuccess((Object)Boolean.TRUE);
                        return;
                    }
                }
            }
            this.search(normalized, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            callback.onSuccess((Object)Boolean.TRUE);
        }
    }

    @Nonnull
    protected String normalize(@Nullable String text) {
        return StringUtil.normalizeSearch((String)text);
    }

    protected abstract void search(@Nonnull String var1, @Nonnull AsyncCallback<Iterable<String>> var2);

    protected abstract void removeFoundWarning();

    protected abstract void showFoundWarning(@Nonnull String var1);

    public final void register() {
        this._field.addChangeHandler((ChangeHandler)this);
        this._field.addKeyDownHandler((KeyDownHandler)this);
        this._field.addKeyUpHandler((KeyUpHandler)this);
        this._field.addKeyPressHandler((KeyPressHandler)this);
        this._field.addFocusHandler((FocusHandler)this);
        this._field.addBlurHandler((BlurHandler)this);
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public void addToWhiteList(@Nullable String text) {
        this._stateMap.put(this.normalize(text), AntiSuggestState.WHITE);
    }
}

