/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.presenter;

import com.google.gwt.user.client.ui.HasOneWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.presenter.ReviewerSelectionPresenter;
import de.justsoftware.onx.common.presentation.client.ui.ReviewerSelectionView;
import de.justsoftware.onx.common.presentation.client.ui.ReviewerSelectionViewListBox;
import de.justsoftware.onx.common.presentation.client.ui.ReviewerSelectionViewTypeAhead;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ReviewerSelectionPresenter
implements ReviewerSelectionView.Presenter {
    private ReviewerSelectionView _reviewerSelectionView;
    private final EntityId _entityId;
    private final SelectionType _selectionType;
    private final int _reviewStage;
    private boolean _showAddButton;
    private boolean _showRemoveButton;
    private RemoveReviewerHandler _removeHandler;
    private AddReviewerHandler _addHandler;
    private ReviewerChangedHandler _reviewerChangedHandler;
    private final ClientFactory _clientFactory;
    @CheckForNull
    private final PersonTeaserModel _defaultSelection;

    public ReviewerSelectionPresenter(ClientFactory clientFactory, EntityId entityId, int reviewStage, SelectionType selectionType, @Nullable PersonTeaserModel defaultSelection) {
        this._clientFactory = clientFactory;
        this._entityId = entityId;
        this._reviewStage = reviewStage;
        this._selectionType = selectionType;
        this._defaultSelection = defaultSelection;
    }

    public void show(HasOneWidget parent) {
        switch (1.$SwitchMap$de$justsoftware$onx$common$presentation$client$presenter$ReviewerSelectionPresenter$SelectionType[this._selectionType.ordinal()]) {
            case 1: {
                this._reviewerSelectionView = new ReviewerSelectionViewTypeAhead((ReviewerSelectionView.Presenter)this, this._clientFactory, this._entityId, this._reviewStage);
                break;
            }
            case 2: {
                this._reviewerSelectionView = new ReviewerSelectionViewListBox((ReviewerSelectionView.Presenter)this, this._clientFactory, this._entityId, this._reviewStage);
                break;
            }
        }
        if (this._reviewerSelectionView != null) {
            parent.setWidget(this._reviewerSelectionView.asWidget());
            this._reviewerSelectionView.setAddButtonVisible(this._showAddButton);
            this._reviewerSelectionView.setRemoveButtonVisible(this._showRemoveButton);
            if (this._defaultSelection != null) {
                this._reviewerSelectionView.setDefaultSelection(this._defaultSelection);
                this._reviewerSelectionView.resetToDefault();
            }
        }
    }

    public void remove() {
        this._reviewerSelectionView.setRemoveButtonVisible(false);
        this._reviewerSelectionView.setAddButtonVisible(false);
        this._reviewerSelectionView.reset();
        if (this._reviewStage > 0) {
            this._reviewerSelectionView.remove();
        }
        if (this._removeHandler != null) {
            this._removeHandler.handleRemove((ReviewerSelectionView.Presenter)this);
        }
    }

    public void addReviewer() {
        this._reviewerSelectionView.setAddButtonVisible(false);
        if (this._addHandler != null) {
            this._addHandler.handleAdd((ReviewerSelectionView.Presenter)this);
        }
    }

    public void valueChanged(@Nullable PersonId value) {
        this.clearError();
        if (this._reviewerChangedHandler != null) {
            this._reviewerChangedHandler.handleValueChanged((ReviewerSelectionView.Presenter)this);
        }
    }

    public int getReviewStage() {
        return this._reviewStage;
    }

    public PersonId getValue() {
        return this._reviewerSelectionView.getValue();
    }

    public void setRemoveHandler(@Nullable RemoveReviewerHandler removeHandler) {
        this._removeHandler = removeHandler;
    }

    public void setAddHandler(@Nullable AddReviewerHandler addHandler) {
        this._addHandler = addHandler;
    }

    public void setReviewerChangedHandler(@Nullable ReviewerChangedHandler reviewerChangedHandler) {
        this._reviewerChangedHandler = reviewerChangedHandler;
    }

    public void addError(String errorMessage) {
        this._reviewerSelectionView.setErrorState(true);
        this._reviewerSelectionView.setHelpMessage(errorMessage);
    }

    public void clearError() {
        this._reviewerSelectionView.setErrorState(false);
        this._reviewerSelectionView.setHelpMessage("");
    }

    public void showAdd(boolean visible) {
        this._showAddButton = visible;
        if (this._reviewerSelectionView != null) {
            this._reviewerSelectionView.setAddButtonVisible(this._showAddButton);
        }
    }

    public void showRemove(boolean visible) {
        this._showRemoveButton = visible;
        if (this._reviewerSelectionView != null) {
            this._reviewerSelectionView.setRemoveButtonVisible(this._showRemoveButton);
        }
    }
}

