/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.common.presentation.ui.NoHistoryHyperlink;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.i18n.AlbumConstants;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.AlbumMediator;
import de.justsoftware.onx.album.presentation.client.ui.AlbumOverviewWidget;
import de.justsoftware.onx.album.presentation.client.ui.AlbumWidget;
import de.justsoftware.onx.album.presentation.client.ui.ImageOverviewHandler;
import de.justsoftware.onx.album.presentation.client.ui.ImageUploadWidget;
import de.justsoftware.onx.album.shared.model.Album;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceOneLineTextBox;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceTextBox;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.upload.OnUploadHandler;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AlbumOverviewWidget
extends Composite {
    private static final int WIDTH = 4;
    private static final int HEIGHT = 3;
    private static final AlbumConstants ALBUM = I18nMediator.ALBUM;
    private static final AlbumOverviewWidgetUIBinder UI_BINDER = (AlbumOverviewWidgetUIBinder)GWT.create(AlbumOverviewWidgetUIBinder.class);
    @UiField
    DivElement _actionsContainer;
    @UiField
    JCButton _showHideUploadTop;
    @UiField
    NoHistoryHyperlink _deleteImageLinkTop;
    @UiField
    NoHistoryHyperlink _deleteAlbumLinkTop;
    @UiField
    InlineFeedbackWidget _errorMessageTop;
    @UiField
    SimplePanel _uploadTopPanel;
    @UiField
    Panel _picturesPanel;
    @UiField
    InPlaceOneLineTextBox _name;
    @UiField
    InPlaceOneLineTextBox _location;
    @UiField
    Element _locationRow;
    @UiField
    InPlaceTextBox _description;
    @UiField
    Element _descriptionRow;
    @UiField
    FlowPanel _ownerPanel;
    @UiField
    Label _createDate;
    @UiField
    Label _lastUploadDate;
    private final AlbumWidget _pictures;
    private final ClientFactory _clientFactory;
    private final PageTitleCallback _titleCallback;
    private final AlbumId _albumId;
    private Album _album;

    public AlbumOverviewWidget(@Nonnull AlbumId albumId, boolean showUpload, @Nonnull PageTitleCallback titleCallback, @Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._titleCallback = titleCallback;
        this._albumId = albumId;
        this._pictures = new AlbumWidget(albumId, 4, 3, false, true, clientFactory.eventManager());
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._pictures.setAlbumPageLoadHandler(arg_0 -> this.updateActions(arg_0));
        this._pictures.setImageClickCallback(image -> {
            if (image != null) {
                History.newItem((String)ImageOverviewHandler.token((AlbumImageId)image.getId()));
            }
        });
        this._picturesPanel.add((Widget)this._pictures);
        this._name.setAsyncEnabled(true);
        this._name.addValueChangeHandler(event -> AlbumMediator.getInstance().updateAlbumTitle(this._albumId, (String)event.getValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        this._location.setAsyncEnabled(true);
        this._location.addValueChangeHandler(event -> AlbumMediator.getInstance().updateAlbumLocation(this._albumId, (String)event.getValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        this._description.setAsyncEnabled(true);
        this._description.addValueChangeHandler(event -> AlbumMediator.getInstance().updateAlbumDescription(this._albumId, (String)event.getValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        this.showUploadPanel(false);
        this._uploadTopPanel.clear();
        this.updateAlbumOverviewWidget();
        if (showUpload) {
            this.showHideUploadTop(null);
        }
    }

    private void updateActions(@Nullable ListAndCount<AlbumImage> result) {
        this._deleteImageLinkTop.setVisible(this.isDeleteImageVisible(result));
    }

    private boolean isDeleteImageVisible(@Nullable ListAndCount<AlbumImage> result) {
        return this._album != null && this._album.getMay().contains(StaticAction.ALBUM_SHOW_ACTIONS) && AlbumWidget.isDeleteImageVisible(result);
    }

    private void setAlbum(@Nonnull Album album) {
        this._album = album;
        boolean editable = this._album.getMay().contains(StaticAction.ALBUM_UPDATE);
        boolean showActions = this._album.getMay().contains(StaticAction.ALBUM_SHOW_ACTIONS);
        this._titleCallback.setPageTitle(this._album.getTitle());
        this._name.setValue((Object)this._album.getTitle());
        this._name.setEditable(editable);
        this._location.setValue((Object)this._album.getLocation());
        this._location.setEditable(editable);
        UIObject.setVisible((Element)this._locationRow, (editable || !StringUtil.isBlank((String)this._album.getLocation()) ? 1 : 0) != 0);
        this._description.setValue((Object)this._album.getDescription());
        UIObject.setVisible((Element)this._descriptionRow, (editable || !StringUtil.isBlank((String)this._album.getDescription()) ? 1 : 0) != 0);
        this._description.setEditable(editable);
        boolean isDeleteAlbumLinkTopVisible = showActions && this._album.getMay().contains(StaticAction.ALBUM_DELETE);
        boolean isShowHideUploadTopVisible = showActions && this._album.getMay().contains(StaticAction.ALBUM_CREATE);
        boolean isDeleteImageLinkTop = this.isDeleteImageVisible(null);
        this._deleteAlbumLinkTop.setVisible(isDeleteAlbumLinkTopVisible);
        this._showHideUploadTop.setVisible(isShowHideUploadTopVisible);
        this._deleteImageLinkTop.setVisible(isDeleteImageLinkTop);
        UIObject.setVisible((Element)this._actionsContainer, (isDeleteAlbumLinkTopVisible || isShowHideUploadTopVisible || isDeleteImageLinkTop ? 1 : 0) != 0);
        this._pictures.setAlbumId(this._albumId);
        this._ownerPanel.clear();
        if (album.getOwner() != null) {
            this._ownerPanel.add(PersonUtil.profileLink((PersonTeaserModel)album.getOwner(), (ClientFactory)this._clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP));
        }
        this._createDate.setText(this._clientFactory.dateFormatter().formatDateTime(album.getCreateDate()));
        this._lastUploadDate.setText(this._clientFactory.dateFormatter().formatDateTime(album.getEditDate()));
    }

    private void updateAlbumOverviewWidget() {
        this._album = null;
        AlbumMediator.getInstance().getAlbumById(this._albumId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showUploadPanel(boolean show) {
        if (show) {
            this._showHideUploadTop.setText(ALBUM.closePictureUploadDialog());
            this._uploadTopPanel.setVisible(true);
            if (!this._uploadTopPanel.iterator().hasNext()) {
                this._uploadTopPanel.setWidget(this.createImageUploadWidget());
            }
        } else {
            this._showHideUploadTop.setText(ALBUM.uploadPhotos());
            this._uploadTopPanel.setVisible(false);
        }
    }

    @UiHandler(value={"_showHideUploadTop"})
    void showHideUploadTop(@Nullable ClickEvent e) {
        this.showUploadPanel(!this._uploadTopPanel.isVisible());
    }

    @UiHandler(value={"_deleteImageLinkTop"})
    void deleteImageLinkTop(@Nonnull ClickEvent e) {
        List deleteList = this._pictures.getToDeleteImages();
        if (deleteList.isEmpty()) {
            this._errorMessageTop.showAndHideAfterDelay(ALBUM.noPhotosSelectedToDelete());
        } else {
            ConfirmPopup.makeConfirmPopup((String)ALBUM.realyWantToDeleteSelectedImages(), event -> AlbumMediator.getInstance().deleteImages(deleteList, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */)).show();
        }
    }

    @UiHandler(value={"_deleteAlbumLinkTop"})
    void deleteAlbumLinkTop(@Nonnull ClickEvent e) {
        ConfirmPopup.makeConfirmPopup((String)ALBUM.reallyWantToDeleteAlbum(), event -> AlbumMediator.getInstance().deleteAlbum(this._albumId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */)).show();
    }

    @Nonnull
    private Widget createImageUploadWidget() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("albumId", Long.toString(this._albumId.getId()));
        7 onUpload = new /* Unavailable Anonymous Inner Class!! */;
        ImageUploadWidget result = new ImageUploadWidget(UrlUtil.generateUploadUrl((String)"/mdlalbum"), parameters);
        result.setOnUploadHandler((OnUploadHandler)onUpload);
        return result;
    }

    @Nonnull
    public AlbumId getAlbumId() {
        return this._albumId;
    }
}

