/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.requestcollect.client;

import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.base.Strings;
import de.justsoftware.gwt.requestcollect.client.RequestProfilerAsyncCallback;
import de.justsoftware.gwt.requestcollect.client.RequestProfilerNode;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

/*
 * Exception performing whole class analysis ignored.
 */
final class RequestProfiler {
    static final RequestProfiler INSTANCE = new RequestProfiler();
    private RequestProfilerNode _currentNode = null;

    private RequestProfiler() {
    }

    static native boolean isEnabled();

    void requestReturned(@Nonnull RequestProfilerAsyncCallback<?> callback, boolean failure) {
        if (this._currentNode != null) {
            throw new IllegalStateException("request (" + callback._node._methodName + ") returned, but there is already a current node (" + this._currentNode._methodName + ")");
        }
        this._currentNode = callback._node;
        this._currentNode.requestReturned(failure);
    }

    void callbackFinished(@Nonnull RequestProfilerAsyncCallback<?> callback) {
        LinkedList path;
        if (!callback._node.equals(this._currentNode)) {
            String currentNodeName = this._currentNode != null ? this._currentNode._methodName : "null";
            throw new IllegalStateException("callbacknode (" + callback._node._methodName + ") and currentnode (" + currentNodeName + ") are not equal");
        }
        this._currentNode.callbackFinished();
        if (this._currentNode.getChildren().isEmpty() && (path = this._currentNode.getPath()).size() > 1) {
            LoggingUtil.warn((Object)this, (String)RequestProfiler.pathToString((List)path));
            RequestProfilerNode root = (RequestProfilerNode)path.getFirst();
            if (root.isFinished()) {
                LoggingUtil.warn((Object)this, (String)RequestProfiler.treeToString((RequestProfilerNode)root));
            }
        }
        this._currentNode = null;
    }

    @Nonnull
    RequestProfilerNode callbackCreated(@Nonnull String methodName) {
        return new RequestProfilerNode(methodName, this._currentNode);
    }

    @Nonnull
    private static String treeToString(@Nonnull RequestProfilerNode root) {
        StringBuilder sb = new StringBuilder("found long request tree:\n");
        sb.append(" request callback methodname\n");
        RequestProfiler.createTreeLine((StringBuilder)sb, (RequestProfilerNode)root, (String)"");
        RequestProfiler.treeToString((List)root.getChildren(), (StringBuilder)sb, (String)"+- ");
        return sb.toString();
    }

    private static void treeToString(@Nonnull List<RequestProfilerNode> childs, @Nonnull StringBuilder sb, @Nonnull String depthString) {
        if (childs.isEmpty()) {
            return;
        }
        String deeperString = "| " + depthString;
        for (RequestProfilerNode child : childs) {
            RequestProfiler.createTreeLine((StringBuilder)sb, (RequestProfilerNode)child, (String)depthString);
            RequestProfiler.treeToString((List)child.getChildren(), (StringBuilder)sb, (String)deeperString);
        }
    }

    private static void createTreeLine(@Nonnull StringBuilder sb, @Nonnull RequestProfilerNode node, @Nonnull String depthString) {
        String request = RequestProfiler.durationToString((long)node.getRequestDuration());
        String callback = RequestProfiler.durationToString((long)node.getCallbackDuration());
        sb.append(request).append(callback).append(depthString).append(node.buildMethodName()).append('\n');
    }

    @Nonnull
    private static String durationToString(long duration) {
        return Strings.padStart((String)String.valueOf(duration), (int)6, (char)' ') + "ms ";
    }

    @Nonnull
    private static String pathToString(@Nonnull List<RequestProfilerNode> path) {
        StringBuilder sb = new StringBuilder("found long request path:\n");
        String arrow = "";
        for (RequestProfilerNode node : path) {
            sb.append(arrow).append(node.buildMethodName());
            arrow = " > ";
        }
        sb.append('\n');
        return sb.toString();
    }
}

