/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.util.client;

import com.freiheit.toro.client.ui.MessagePopup;
import com.freiheit.toro.common.presentation.ui.NoHistoryHyperlink;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.util.client.LoggingUtil;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WidgetUtil {
    public static final boolean IS_AFTER_LAUNCH = false;
    public static final String SEP = "\uffff";
    private static final String KEY_PRFIX = "key_w_";
    private static final String LINK_START = "<a>";
    private static final String LINK_END = "</a>";
    private static volatile MessagePopup _popupSingleton;

    private WidgetUtil() {
    }

    @CheckForNull
    public static JCDialogBox showPopUp(int messageType, @Nonnull String message, @Nullable CloseHandler<PopupPanel> handler) {
        if (!ClientStringUtil.hasText((String)message)) {
            LoggingUtil.warn((Object)"Got empty message for Popup", null);
            return null;
        }
        MessagePopup popup = WidgetUtil.getFakeSingletonMessageBox();
        if (popup != null) {
            popup.setType(messageType);
            popup.setMessage(message);
            if (handler != null) {
                popup.addCloseHandler(handler);
            }
            popup.show();
        }
        return popup;
    }

    @CheckForNull
    public static JCDialogBox showPopUp(int messageType, String message) {
        return WidgetUtil.showPopUp((int)messageType, (String)message, null);
    }

    @CheckForNull
    public static JCDialogBox showPopUp(int messageType, Widget message) {
        MessagePopup popup = WidgetUtil.getFakeSingletonMessageBox();
        if (popup != null) {
            popup.setType(messageType);
            popup.setMessage(message);
            popup.show();
        }
        return popup;
    }

    public static String getSelectedValue(ListBox listBox) {
        int index = listBox.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        String value = listBox.getValue(index);
        return value.equals("-1") ? null : value;
    }

    public static MessagePopup getFakeSingletonMessageBox() {
        if (_popupSingleton == null) {
            _popupSingleton = new MessagePopup(false, true);
            return _popupSingleton;
        }
        if (_popupSingleton.isShown()) {
            return null;
        }
        _popupSingleton = new MessagePopup(false, true);
        return _popupSingleton;
    }

    public static <P extends HasWidgets.ForIsWidget> P i18nLinkedText(String[] linkedTextArray, Map<String, ? extends IsWidget> widgetMap, P res) {
        for (String str : linkedTextArray) {
            if (StringUtil.isBlank((String)str)) continue;
            IsWidget w = widgetMap.get(str);
            if (w != null) {
                res.add(w);
                continue;
            }
            res.add((Widget)new InlineLabel(str));
        }
        return res;
    }

    public static <P extends HasWidgets.ForIsWidget> P i18nLinkedText(String messages, Map<String, ? extends IsWidget> widgetMap, P panel) {
        return (P)WidgetUtil.i18nLinkedText((String[])messages.split("\uffff"), widgetMap, panel);
    }

    public static <P extends HasWidgets.ForIsWidget> P i18nLinkedText(Iterator<? extends IsWidget> widgets, String messages, P panel) {
        HashMap<String, IsWidget> widgetMap = new HashMap<String, IsWidget>();
        int i = 0;
        while (widgets.hasNext()) {
            widgetMap.put(WidgetUtil.getKey((int)i++), widgets.next());
        }
        return (P)WidgetUtil.i18nLinkedText((String)messages, widgetMap, panel);
    }

    @ParametersAreNonnullByDefault
    public static <P extends HasWidgets.ForIsWidget> P i18nLinkedText(Iterable<? extends IsWidget> widgets, String messages, P panel) {
        return (P)WidgetUtil.i18nLinkedText(widgets.iterator(), (String)messages, panel);
    }

    @Nonnull
    public static ImmutableList<IsWidget> i18nLinkedText(Iterable<? extends IsWidget> widgets, String messages) {
        return ((HasWidgetsListBuilder)WidgetUtil.i18nLinkedText(widgets, (String)messages, (HasWidgets.ForIsWidget)new HasWidgetsListBuilder())).build();
    }

    public static <P extends HasWidgets.ForIsWidget> P i18nLinkedText(String message, P panel, IsWidget ... widgets) {
        return (P)WidgetUtil.i18nLinkedText((Iterable)ImmutableList.copyOf((Object[])widgets), (String)message, panel);
    }

    public static String getWrappedKey(int i) {
        return WidgetUtil.wrapKey((String)WidgetUtil.getKey((int)i));
    }

    public static String wrapKey(String key) {
        return "\uffff" + key + "\uffff";
    }

    public static String getKey(int i) {
        return "key_w_" + i;
    }

    public static FlowPanel layoutFixWrapPanelInFlowPanel(Panel p) {
        FlowPanel fp = new FlowPanel();
        fp.add((Widget)p);
        return fp;
    }

    public static Hyperlink trimLongHyperlinks(Hyperlink h, int maxLetterCount) {
        if (h == null) {
            return h;
        }
        h.setHTML(ClientStringUtil.splitStringAtCharPos((int)maxLetterCount, (String)h.getHTML(), (String)"<br/>"));
        return h;
    }

    public static Widget replaceLink(String s, Widget widget, HasText hasText) {
        FlowPanel result = new FlowPanel();
        int startIndex = s.indexOf("<a>");
        int endIndex = s.indexOf("</a>");
        if (startIndex < 0 || endIndex < 0) {
            return new HTML(s);
        }
        String prefix = s.substring(0, startIndex);
        String link = s.substring(startIndex + "<a>".length(), endIndex);
        String suffix = s.substring(endIndex + "</a>".length());
        if (prefix.length() > 0) {
            result.add((Widget)new InlineLabel(prefix));
        }
        if (link.length() > 0) {
            result.add(widget);
            hasText.setText(link);
        }
        if (suffix.length() > 0) {
            result.add((Widget)new InlineLabel(suffix));
        }
        result.addStyleName("inlinePanel");
        return result;
    }

    public static Widget insertNoHistoryHyperlink(@Nonnull String s, @Nonnull ClickHandler clickHandler) {
        NoHistoryHyperlink hyperlink = new NoHistoryHyperlink("", clickHandler);
        return WidgetUtil.replaceLink((String)s, (Widget)hyperlink);
    }

    public static Widget insertHyperLink(@Nonnull String s, @Nonnull String historyToken) {
        Hyperlink hyperLink = new Hyperlink("", historyToken);
        return WidgetUtil.replaceLink((String)s, (Widget)hyperLink);
    }

    private static <W extends Widget> Widget replaceLink(@Nonnull String s, @Nonnull W hyperLink) {
        return WidgetUtil.replaceLink((String)s, hyperLink, (HasText)((HasText)hyperLink));
    }

    public static ImmutableList<IsWidget> join(Iterator<? extends IsWidget> toJoin, String seperator) {
        return ((HasWidgetsListBuilder)WidgetUtil.join((HasWidgets.ForIsWidget)new HasWidgetsListBuilder(), toJoin, (String)seperator)).build();
    }

    public static <T extends HasWidgets.ForIsWidget> T join(T hasWidgets, Iterator<? extends IsWidget> toJoin, String seperator) {
        if (!toJoin.hasNext()) {
            return hasWidgets;
        }
        hasWidgets.add(toJoin.next());
        while (toJoin.hasNext()) {
            hasWidgets.add((Widget)new InlineLabel(seperator));
            hasWidgets.add(toJoin.next());
        }
        return hasWidgets;
    }

    public static boolean toggleStyle(@Nonnull UIObject widget, @Nonnull String cssClass) {
        String before = widget.getStyleName();
        widget.addStyleName(cssClass);
        boolean notAdded = Objects.equal((Object)before, (Object)widget.getStyleName());
        if (notAdded) {
            widget.removeStyleName(cssClass);
        }
        return !notAdded;
    }

    public static void setAutocompleteOff(@Nonnull UIObject widget) {
        widget.getElement().setPropertyString("autocomplete", "off");
    }

    @Nonnull
    public static FlowPanel flowPanel(IsWidget ... widgets) {
        FlowPanel flowPanel = new FlowPanel();
        for (IsWidget w : widgets) {
            flowPanel.add(w);
        }
        return flowPanel;
    }
}

