/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.tag.presentation.ui;

import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.searchnew.presentation.client.ClientSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;

public class TagsWidget
extends FlowPanel {
    private FilterType _filterType;
    private int _maxLetterCountPerLine = 35;
    private String[] _tags;

    public TagsWidget() {
        this._filterType = null;
        this._tags = new String[0];
    }

    public TagsWidget(String tags, FilterType filterType) {
        this.setFilterType(filterType);
        this.setTags(tags);
    }

    protected void initGUI() {
        this.addStyleName("tags");
        this.clear();
        if (this._tags != null && this._tags.length > 0) {
            for (int i = 0; i < this._tags.length; ++i) {
                FlowPanel wrapper = new FlowPanel();
                wrapper.addStyleName("wrapper");
                wrapper.add((Widget)this.getTagLink(this._tags[i].trim()));
                if (i + 1 < this._tags.length && ClientStringUtil.hasText((String)this._tags[i + 1])) {
                    wrapper.add((Widget)new Label(", "));
                }
                this.add((Widget)wrapper);
            }
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    private Hyperlink getTagLink(String tag) {
        Hyperlink tagLink = new Hyperlink(tag, SearchHandler.tokenFor((SearchParameters)SearchHandler.parameters((FilterType)this._filterType, (SearchContext)SearchContext.ENTIRE_PLATFORM).withDefaultSortTypeAndSubfilter(ClientSearchConfigurationProvider.INSTANCE).withAdditionalSubfilter((SubFilter)new TagSubFilter(tag.toLowerCase()))));
        return WidgetUtil.trimLongHyperlinks((Hyperlink)tagLink, (int)this._maxLetterCountPerLine);
    }

    public int getMaxTagsLetterCount() {
        return this._maxLetterCountPerLine;
    }

    public void setMaxTagsLetterCount(int maxTagsLetterCount) {
        this._maxLetterCountPerLine = maxTagsLetterCount;
    }

    public FilterType getFilterType() {
        return this._filterType;
    }

    public void setFilterType(FilterType filterType) {
        this._filterType = filterType;
    }

    public void setTags(String[] tags) {
        this._tags = new String[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            this._tags[i] = tags[i].trim();
        }
        this.initGUI();
    }

    public void setTags(String tags) {
        this.setTags(ClientStringUtil.hasText((String)tags) ? tags.split(",") : new String[]{});
    }
}

