/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server.upload;

import com.freiheit.toro.server.upload.UploadResult;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public class CKEditorUploadResult
implements UploadResult {
    private final JSONObject _response;

    private CKEditorUploadResult(String fileName, @Nullable String fileUrl, @Nullable String errorMessage) {
        try {
            this._response = new JSONObject();
            this._response.put("uploaded", errorMessage == null ? 1 : 0).put("fileName", (Object)fileName).put("url", (Object)fileUrl);
            if (errorMessage != null) {
                this._response.put("error", (Object)new JSONObject().put("message", (Object)errorMessage));
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static CKEditorUploadResult success(String fileName, String fileURL) {
        return new CKEditorUploadResult(fileName, fileURL, null);
    }

    public static CKEditorUploadResult error(String errorMessage) {
        return new CKEditorUploadResult(null, null, errorMessage);
    }

    public String getContentType() {
        return "application/json";
    }

    public String getContent() {
        return this._response.toString();
    }
}

