/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.account.presentation.ui;

import com.freiheit.toro.account.presentation.ui.AbstractWriteMessageWidget;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.Mediated;
import com.freiheit.toro.client.ui.RemainingTextAreaWidget;
import com.freiheit.toro.common.presentation.client.ErrorHandlingAsyncCallback;
import com.freiheit.toro.common.presentation.ui.LoadingDialog;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractWriteMessageWidget<T extends Widget>
extends JCDialogBox {
    private static final BasicConstants BASIC = I18nMediator.BASIC;
    private static final int MAX_SUBJECT_LEN = 255;
    protected final T _additionalToWidget;
    private final int _maxChars;
    private final FlexTable _form = new FlexTable();
    private final RemainingTextAreaWidget _msgBody;
    private final TextBox _subject = new TextBox();
    private final LoadingDialog _loadingDialog = new LoadingDialog();
    private final JCButton _sendBtn = new JCButton(BASIC.absenden(), (ClickHandler)new SendClickHandler(this));
    private final Mediated _parent;
    private final ErrorHandlingAsyncCallback<Void> _sendMsgErrorHandlingAsyncCallback = new /* Unavailable Anonymous Inner Class!! */;

    public AbstractWriteMessageWidget(Mediated parent, @Nullable T additionalToWidget) {
        super(false, true);
        this._additionalToWidget = additionalToWidget;
        this._maxChars = HostPropertiesMediator.getHostPropertiesBean().getMaxDirectMessageLength();
        this._parent = parent;
        Label charCount = new Label(Integer.toString(this._maxChars) + "/" + Integer.toString(this._maxChars));
        charCount.setStyleName("smallText");
        this._subject.setMaxLength(255);
        this._msgBody = new RemainingTextAreaWidget(this._maxChars, charCount);
        if (additionalToWidget != null) {
            this.addWidgetRow((Widget)new Label(BASIC.empfaenger() + ":"), additionalToWidget);
        }
        this._sendBtn.addStyleName("msgSendBtn");
        this.addWidgetRow((Widget)new Label(BASIC.betreff() + ":"), (Widget)this._subject);
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)this._msgBody);
        vp.add((Widget)charCount);
        this.addWidgetRow((Widget)new Label(BASIC.message() + ":"), (Widget)vp);
        this.addButton(this._sendBtn);
        this.addButton(new JCButton(BASIC.abbrechen(), (ClickHandler)new ConfirmHandler(this)));
        this._form.addStyleName("writeMessage");
        this.setContent((IsWidget)this._form);
        this.setText(this.getPopUpTitle());
    }

    protected abstract String getPopUpTitle();

    private void enableInputFields(boolean active) {
        this._subject.setEnabled(active);
        this._msgBody.setEnabled(active);
        this._sendBtn.setEnabled(active);
    }

    private void addWidgetRow(Widget key, Widget input) {
        int row = this._form.getRowCount();
        this._form.setWidget(row, 0, key);
        this._form.setWidget(row, 1, input);
        this._form.getCellFormatter().setStyleName(row, 0, "description");
        this._form.getCellFormatter().setVerticalAlignment(row, 0, HasVerticalAlignment.ALIGN_TOP);
        this._form.getCellFormatter().setStyleName(row, 1, "value");
    }

    private boolean isModified() {
        return ClientStringUtil.hasText((String)this._msgBody.getText()) || ClientStringUtil.hasText((String)this._subject.getText());
    }

    public void setSubject(String subject) {
        this._subject.setText(StringUtil.limitStringWithDots((String)subject, (int)255));
    }

    public void setMsgBody(String body) {
        this._msgBody.setText(body);
        this._msgBody.setCursorPos(0);
    }

    @OverridingMethodsMustInvokeSuper
    protected void validate(StringBuilder errorBuilder) {
        if (StringUtil.isBlank((String)this._msgBody.getText())) {
            errorBuilder.append(BASIC.sendingEmptyMessagesNotPossible()).append("\n");
        } else if (this._msgBody.getText().length() > this._maxChars) {
            errorBuilder.append(I18nMediator.BASIC_MESSAGES.messageTextTooLong(this._maxChars)).append("\n");
        }
    }

    protected abstract void sendMessage(String var1, String var2, AsyncCallback<Void> var3);
}

