/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.training;

import de.justsoftware.searchltr.training.TrainingScheduler;
import de.justsoftware.searchltr.training.TrainingService;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\u00032\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/searchltr/training/TrainingScheduler;", "", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "trainingService", "Lde/justsoftware/searchltr/training/TrainingService;", "trainingCronExpr", "", "trainingNotStartBefore", "(Lorg/springframework/scheduling/TaskScheduler;Lde/justsoftware/searchltr/training/TrainingService;Ljava/lang/String;Ljava/lang/String;)V", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "cronExpression", "task", "Ljava/lang/Runnable;", "Companion", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nTrainingScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrainingScheduler.kt\nde/justsoftware/searchltr/training/TrainingScheduler\n+ 2 LoggerUtils.kt\nde/justsoftware/searchltr/util/LoggerUtilsKt\n*L\n1#1,48:1\n9#2:49\n8#2,3:50\n*S KotlinDebug\n*F\n+ 1 TrainingScheduler.kt\nde/justsoftware/searchltr/training/TrainingScheduler\n*L\n45#1:49\n45#1:50,3\n*E\n"})
public class TrainingScheduler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final TrainingService trainingService;
    @NotNull
    private final String trainingCronExpr;
    @NotNull
    private static final Logger LOG;

    public TrainingScheduler(@NotNull TaskScheduler taskScheduler, @NotNull TrainingService trainingService, @Value(value="${search-ltr.training.cronExpression}") @NotNull String trainingCronExpr, @Value(value="${search-ltr.training.notStartBefore}") @NotNull String trainingNotStartBefore) {
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)trainingService, (String)"trainingService");
        Intrinsics.checkNotNullParameter((Object)trainingCronExpr, (String)"trainingCronExpr");
        Intrinsics.checkNotNullParameter((Object)trainingNotStartBefore, (String)"trainingNotStartBefore");
        this.trainingService = trainingService;
        this.trainingCronExpr = trainingCronExpr;
        Instant notStartBefore = Instant.parse(trainingNotStartBefore);
        LOG.info("Starting TrainCron with {}.", (Object)this.trainingCronExpr);
        this.schedule(taskScheduler, this.trainingCronExpr, () -> TrainingScheduler._init_$lambda$0(notStartBefore, trainingNotStartBefore, this));
    }

    private ScheduledFuture<?> schedule(TaskScheduler $this$schedule, String cronExpression, Runnable task) {
        ScheduledFuture scheduledFuture;
        try {
            scheduledFuture = $this$schedule.schedule(task, (Trigger)new CronTrigger(cronExpression));
        }
        catch (IllegalArgumentException e) {
            LOG.error("An illegal argument exception was raised. Make sure the supplied cron expression is valid.", (Throwable)e);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    private static final void _init_$lambda$0(Instant $notStartBefore, String $trainingNotStartBefore, TrainingScheduler this$0) {
        Intrinsics.checkNotNullParameter((Object)$trainingNotStartBefore, (String)"$trainingNotStartBefore");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.info("Starting TrainCron job...");
        if (Instant.now().isBefore($notStartBefore)) {
            LOG.info("Skip training since training should not start before " + $trainingNotStartBefore + ". Only prepare training for next time...");
            this$0.trainingService.prepareTraining();
        } else {
            this$0.trainingService.train();
        }
        LOG.info("TrainCron job finished.");
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

