/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.permission.persistence.RowMapper;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;

@ParametersAreNonnullByDefault
public interface SqlResultBuilder {
    @CheckForNull
    public <R> R query(ResultSetExtractor<R> var1);

    public void forEachRow(RowCallbackHandler var1);

    public int update();

    @Nonnull
    default public <T, A, R> R collect(RowMapper<T> rowMapper, Collector<T, A, R> collector) {
        Object result = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        this.forEachRow(rs -> accumulator.accept(result, rowMapper.mapRow(rs)));
        return collector.finisher().apply(result);
    }

    @Nonnull
    default public <T> ImmutableSet<T> set(RowMapper<T> rowMapper) {
        return (ImmutableSet)this.collect(rowMapper, ImmutableSet.toImmutableSet());
    }

    @Nonnull
    default public <T> ImmutableList<T> list(RowMapper<T> rowMapper) {
        return (ImmutableList)this.collect(rowMapper, ImmutableList.toImmutableList());
    }

    @Nonnull
    default public <K, V> ImmutableMap<K, V> map(RowMapper<Map.Entry<K, V>> rowMapper) {
        return (ImmutableMap)this.collect(rowMapper, ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    default public <K, V> ImmutableMap<K, V> map(RowMapper<K> keyRowMapper, RowMapper<V> valueRowMapper) {
        return this.map(RowMapper.entryMapper(keyRowMapper, valueRowMapper));
    }

    @Nonnull
    default public <K, V> ImmutableSetMultimap<K, V> setMultimap(RowMapper<Map.Entry<K, V>> rowMapper) {
        return (ImmutableSetMultimap)this.collect(rowMapper, ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    default public <K, V> ImmutableSetMultimap<K, V> setMultimap(RowMapper<K> keyRowMapper, RowMapper<V> valueRowMapper) {
        return this.setMultimap(RowMapper.entryMapper(keyRowMapper, valueRowMapper));
    }

    @Nonnull
    default public <K, V> ImmutableListMultimap<K, V> listMultimap(RowMapper<Map.Entry<K, V>> rowMapper) {
        return (ImmutableListMultimap)this.collect(rowMapper, ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    default public <K, V> ImmutableListMultimap<K, V> listMultimap(RowMapper<K> keyRowMapper, RowMapper<V> valueRowMapper) {
        return this.listMultimap(RowMapper.entryMapper(keyRowMapper, valueRowMapper));
    }

    @CheckForNull
    default public <T> T singleObject(RowMapper<T> rowMapper) {
        ImmutableList resultList = this.list(rowMapper);
        return (T)(resultList.isEmpty() ? null : resultList.get(0));
    }
}

