/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.usergroup;

import de.justsoftware.news.domain.user.UserService;
import de.justsoftware.news.id.UserGroupId;
import de.justsoftware.news.kafka.usergroup.UserGroupKafkaDto;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/news/kafka/usergroup/KafkaUserGroupConsumer;", "", "userService", "Lde/justsoftware/news/domain/user/UserService;", "(Lde/justsoftware/news/domain/user/UserService;)V", "listen", "", "key", "", "payload", "Lde/justsoftware/news/kafka/usergroup/UserGroupKafkaDto;", "news-service"})
public class KafkaUserGroupConsumer {
    @NotNull
    private final UserService userService;

    public KafkaUserGroupConsumer(@NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.userService = userService;
    }

    @KafkaListener(containerFactory="userGroupListenerContainerFactory", topics={"just.people.userGroup"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload(required=false) @Nullable UserGroupKafkaDto payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (payload == null) {
            this.userService.deleteUserGroup(UserGroupId.Companion.fromString(key));
        } else {
            this.userService.upsertUserGroup(payload.toUserGroup());
        }
    }
}

