/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.subscription;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.subscription.ChannelSubscription;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscription;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscriptionRepo;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PersonalSubscriptionId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Unauthorized;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0016JC\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;", "", "personalSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "(Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;)V", "countSubscribersForChannel", "", "channelId", "Lde/justsoftware/news/id/ChannelId;", "query", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "(Lde/justsoftware/news/id/ChannelId;Ljava/lang/String;Lde/justsoftware/news/auth/AuthorizationContext;)Ljava/lang/Integer;", "deletePersonalSubscriptions", "", "event", "Lde/justsoftware/news/events/ProfileDeletedEvent;", "findOwnSubscriptionsForChannelIds", "", "Lde/justsoftware/news/domain/subscription/ChannelSubscription;", "channelIds", "findSubscribersForChannelId", "Lde/justsoftware/news/domain/user/Profile;", "limit", "offset", "(Lde/justsoftware/news/id/ChannelId;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Lde/justsoftware/news/auth/AuthorizationContext;)Ljava/util/List;", "subscribe", "notificationsEnabled", "", "unsubscribe", "news-service"})
public class ChannelSubscriptionService {
    @NotNull
    private final PersonalSubscriptionRepo personalSubscriptionRepo;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;

    public ChannelSubscriptionService(@NotNull PersonalSubscriptionRepo personalSubscriptionRepo, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper) {
        Intrinsics.checkNotNullParameter((Object)personalSubscriptionRepo, (String)"personalSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        this.personalSubscriptionRepo = personalSubscriptionRepo;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
    }

    @NotNull
    public ChannelSubscription subscribe(@NotNull ChannelId channelId, boolean notificationsEnabled, @NotNull AuthorizationContext authContext) {
        PersonalSubscription personalSubscription;
        ChannelSubscription channelSubscription;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)channelId);
        ChannelSubscription channelSubscription2 = channelSubscription = this.subscriptionRepoWrapper.findSubscription(channelId, authContext.getUser());
        boolean bl = channelSubscription2 != null ? channelSubscription2.getMandatory() : false;
        if (bl) {
            throw new IllegalArgumentException("A mandatory subscription can't be subscribed.");
        }
        PersonalSubscription originSubscription = this.personalSubscriptionRepo.findByChannelIdAndProfileId(channelId, authContext.getUser());
        if (originSubscription == null) {
            PersonalSubscriptionRepo.insert$default((PersonalSubscriptionRepo)this.personalSubscriptionRepo, (PersonalSubscriptionId)PersonalSubscriptionId.Companion.random(), (ChannelId)channelId, (ProfileId)authContext.getUser(), (boolean)notificationsEnabled, (boolean)false, (int)16, null);
            personalSubscription = this.personalSubscriptionRepo.getByChannelIdAndProfileId(channelId, authContext.getUser());
        } else {
            PersonalSubscription update2 = PersonalSubscription.copy$default((PersonalSubscription)originSubscription, null, null, null, (boolean)notificationsEnabled, (boolean)false, (int)7, null);
            Object object = this.personalSubscriptionRepo.save((Object)update2);
            Intrinsics.checkNotNull((Object)object);
            personalSubscription = (PersonalSubscription)object;
        }
        PersonalSubscription updated = personalSubscription;
        return this.subscriptionRepoWrapper.getSubscription(updated.getChannelId(), updated.getProfileId());
    }

    public void unsubscribe(@NotNull ChannelId channelId, @NotNull AuthorizationContext authContext) {
        ChannelSubscription channelSubscription;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)channelId);
        ChannelSubscription channelSubscription2 = channelSubscription = this.subscriptionRepoWrapper.findSubscription(channelId, authContext.getUser());
        boolean bl = channelSubscription2 != null ? channelSubscription2.getMandatory() : false;
        if (bl) {
            throw new IllegalArgumentException("A mandatory subscription can't be unsubscribed.");
        }
        PersonalSubscription originSubscription = this.personalSubscriptionRepo.findByChannelIdAndProfileId(channelId, authContext.getUser());
        if (originSubscription == null) {
            this.personalSubscriptionRepo.insert(PersonalSubscriptionId.Companion.random(), channelId, authContext.getUser(), false, true);
        } else {
            authContext.checkUserEqual(originSubscription.getProfileId());
            this.personalSubscriptionRepo.save((Object)PersonalSubscription.copy$default((PersonalSubscription)originSubscription, null, null, null, (boolean)false, (boolean)true, (int)15, null));
        }
    }

    @Nullable
    public List<Profile> findSubscribersForChannelId(@NotNull ChannelId channelId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String query, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)channelId);
        if (!authContext.mayChannelAction(channelId, ChannelAction.READ_SUBSCRIBERS)) {
            return null;
        }
        return this.subscriptionRepoWrapper.getSubscribersByChannel(channelId, limit, offset, query);
    }

    @Nullable
    public Integer countSubscribersForChannel(@NotNull ChannelId channelId, @Nullable String query, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!authContext.mayChannelAction(channelId, ChannelAction.READ_SUBSCRIBERS)) {
            return null;
        }
        return this.subscriptionRepoWrapper.countSubscribersByChannel(channelId, query);
    }

    @NotNull
    public List<ChannelSubscription> findOwnSubscriptionsForChannelIds(@NotNull List<ChannelId> channelIds, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadAll((Collection)channelIds);
        return this.subscriptionRepoWrapper.findSubscriptions(channelIds, authContext.getUser());
    }

    @EventListener
    @Unauthorized
    public void deletePersonalSubscriptions(@NotNull ProfileDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.personalSubscriptionRepo.deleteByProfileId(event.getProfileId());
    }
}

