--liquibase formatted sql

--changeset bjrke:add_timestamps dbms:postgresql runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION update_mtime()
RETURNS TRIGGER AS $$
BEGIN
   NEW.mtime = clock_timestamp();
   RETURN NEW;
END;
$$ language 'plpgsql';

CREATE OR REPLACE FUNCTION ctime_mtime_columns(tname TEXT)
RETURNS VOID AS $$
BEGIN
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN ctime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN mtime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW EXECUTE PROCEDURE update_mtime();';
END;
$$ language 'plpgsql';

--changeset bjrke:add_now_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION now
    RETURN DATE
AS
BEGIN
    RETURN SYSDATE;
END now;

--changeset bjrke:add_clock_timestamp_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION clock_timestamp
    RETURN TIMESTAMP WITH TIME ZONE
AS
BEGIN
    RETURN SYSTIMESTAMP;
END clock_timestamp;

--changeset bjrke:add_timestamps dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE PROCEDURE ctime_mtime_columns(tname VARCHAR2)
IS
BEGIN
    EXECUTE IMMEDIATE 'ALTER TABLE ' || tname || ' ADD (ctime TIMESTAMP DEFAULT SYSDATE NOT NULL,mtime TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL )';
    EXECUTE IMMEDIATE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW BEGIN :new.mtime := SYSTIMESTAMP; END;';
END ctime_mtime_columns;


--changeset mdoelle:create_external_id_mapping_table
CREATE TABLE external_id_mapping (
    tenant_id ${uuid} NOT NULL,
    external_system ${varchar255} NOT NULL,
    internal_id ${varchar255} NOT NULL,
    external_id ${varchar255} NOT NULL
);
${execute} ctime_mtime_columns('external_id_mapping');

--changeset mdoelle:add_constraints_for_external_id_mapping
ALTER TABLE external_id_mapping ADD CONSTRAINT ex_id_m_internal_uq UNIQUE (tenant_id, external_system, internal_id);
ALTER TABLE external_id_mapping ADD CONSTRAINT ex_id_m_external_uq UNIQUE (tenant_id, external_system, external_id);

--changeset maxse:add_profile_table
CREATE TABLE profile (
    id ${int64} NOT NULL PRIMARY KEY,
    email ${varchar1024},
    full_name ${varchar1024} NOT NULL,
    first_name ${varchar255} NOT NULL,
    last_name ${varchar255} NOT NULL,
    image_url ${varchar4000},
    profile_url ${varchar4000},
    active ${bool} NOT NULL,
    blocked ${bool} NOT NULL,
    deleted ${bool} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);
${execute} ctime_mtime_columns('profile');

--changeset maxse:add_user_group_table
CREATE TABLE user_group (
    id ${uuid} NOT NULL PRIMARY KEY,
    name ${varchar255} NOT NULL,
    tenant_id ${uuid} NOT NULL,
    is_all_tenant_users_group ${bool} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);
${execute} ctime_mtime_columns('user_group');

--changeset pheinicke:add_imported_column_to_profile_and_group_table
ALTER TABLE profile ADD imported_at ${timestamp};
ALTER TABLE profile ADD import_method ${varchar255};
ALTER TABLE user_group ADD imported_at ${timestamp};
ALTER TABLE user_group ADD import_method ${varchar255};

--changeset maxse:recreate_profile_table
DROP TABLE profile;
CREATE TABLE profile (
    id ${int64},
    uuid ${uuid} NOT NULL PRIMARY KEY,
    email ${varchar1024} NOT NULL,
    imported_at ${timestamp},
    import_method ${varchar255},
    full_name ${varchar1024} NOT NULL,
    first_name ${varchar255} NOT NULL,
    last_name ${varchar255} NOT NULL,
    image_url ${varchar4000},
    profile_url ${varchar4000},
    active ${bool} NOT NULL,
    blocked ${bool} NOT NULL,
    deleted ${bool} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL,
    CONSTRAINT profile_id_uq UNIQUE (id),
    CONSTRAINT profile_email_uq UNIQUE (email)
);

--changeset pheinicke:create_user_group_member_table
CREATE TABLE user_group_member (
    profile_id ${uuid} NOT NULL,
    user_group_id ${uuid} NOT NULL,
    imported_at ${timestamp},
    import_method ${varchar255},
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL,
    CONSTRAINT pk_user_group_member PRIMARY KEY (profile_id, user_group_id)
);

ALTER TABLE user_group_member
    ADD CONSTRAINT fk_profile_id FOREIGN KEY (profile_id) REFERENCES profile (uuid);
ALTER TABLE user_group_member
    ADD CONSTRAINT fk_user_group_id FOREIGN KEY (user_group_id) REFERENCES user_group (id);

--changeset maxse:add_tenant_id_to_profile
ALTER TABLE profile ADD tenant_id ${uuid};
