/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.kafka.impl;

import de.justsoftware.justimport.kafka.model.KafkaProfile;
import de.justsoftware.justimport.kafka.model.KafkaProfileDeserializer;
import de.justsoftware.justimport.kafka.model.KafkaUserGroup;
import de.justsoftware.justimport.kafka.model.KafkaUserGroupDeserializer;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;

@Configuration
@EnableKafka
@ParametersAreNonnullByDefault
public class KafkaConsumerConfiguration {
    private final String _bootstrapServers;
    private final int _defaultMaxChunkSize;

    @Autowired
    public KafkaConsumerConfiguration(@Value(value="${just.import.kafka.bootstrapServers:}") String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:100}") int defaultMaxChunkSize) {
        this._bootstrapServers = bootstrapServers;
        this._defaultMaxChunkSize = defaultMaxChunkSize;
    }

    @Nonnull
    private HashMap<String, Object> defaultConsumerConfig(String groupId) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("enable.auto.commit", "false");
        config.put("auto.offset.reset", "earliest");
        config.put("bootstrap.servers", this._bootstrapServers);
        config.put("max.poll.records", this._defaultMaxChunkSize);
        config.put("group.id", groupId);
        return config;
    }

    @Nonnull
    private <K, V> ConcurrentKafkaListenerContainerFactory<K, V> newConsumerFactoryPropsWithDefaults(String groupId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        HashMap props = this.defaultConsumerConfig(groupId);
        factory.setBatchListener(Boolean.valueOf(true));
        ExponentialBackOff exponentialBackoff = new ExponentialBackOff();
        exponentialBackoff.setMaxElapsedTime(Duration.ofHours(1L).toMillis());
        factory.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler((BackOff)exponentialBackoff));
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)props, keyDeserializer, valueDeserializer));
        return factory;
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, KafkaProfile>> profileListenerContainerFactory() {
        return this.newConsumerFactoryPropsWithDefaults("just.import-service.profileConsumer", (Deserializer)new StringDeserializer(), (Deserializer)new KafkaProfileDeserializer());
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, KafkaUserGroup>> userGroupListenerContainerFactory() {
        return this.newConsumerFactoryPropsWithDefaults("just.import-service.userGroupConsumer", (Deserializer)new StringDeserializer(), (Deserializer)new KafkaUserGroupDeserializer());
    }
}

