/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.config;

import com.google.common.collect.ImmutableMap;
import com.unboundid.scim2.common.exceptions.ScimException;
import de.justsoftware.justimport.config.ImportExceptionHandler;
import de.justsoftware.justimport.controller.ErrorCode;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Configuration
@ControllerAdvice
@ParametersAreNonnullByDefault
public class ImportExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ImportExceptionHandler.class);

    @Nonnull
    private ResponseEntity<ErrorModel> handle(ErrorCode errorCode, LogLevel logLevel, RuntimeException e) {
        ErrorModel error = new ErrorModel(errorCode, (Map)ImmutableMap.of());
        logLevel.log((Throwable)e, error.getUuid());
        return new ResponseEntity((Object)error, (HttpStatusCode)error.getErrorCode().getHttpStatus());
    }

    @Nonnull
    @ExceptionHandler(value={ScimException.class})
    public ResponseEntity<String> handleScimException(ScimException e) {
        return new ResponseEntity((Object)e.getMessage(), HttpStatusCode.valueOf((int)e.getScimError().getStatus()));
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleRuntimeException(RuntimeException e) {
        return this.handle(ErrorCode.UNKNOWN, LogLevel.ERROR, e);
    }
}

