/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business;

import de.justsoftware.justimport.business.model.ToroProfile;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.util.ObjectUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@ParametersAreNonnullByDefault
public class ToroApiService {
    private final WebClient _webClient;
    private final String _toroUrl;

    @Autowired
    public ToroApiService(@Value(value="${just.toro.internal.baseurl}") String toroUrl, WebClient webClient) {
        this._webClient = webClient;
        this._toroUrl = toroUrl;
    }

    @Nonnull
    public ToroProfile createProfile(String email, String firstName, String lastName, TenantId tenantId, boolean active) {
        ToroProfile profile = (ToroProfile)((WebClient.RequestBodySpec)this._webClient.post().uri(this.getScimUsersUri(tenantId))).bodyValue(Map.of("email", email, "firstName", firstName, "lastName", lastName, "active", active)).retrieve().bodyToMono(ToroProfile.class).onErrorMap(t -> new IllegalStateException(t.getMessage(), (Throwable)t)).block();
        return (ToroProfile)ObjectUtil.requireNonNull((Object)profile, (String)"Toro did not return a profile");
    }

    @Nonnull
    public ToroProfile replaceProfile(ProfileId id, String email, String firstName, String lastName, TenantId tenantId, boolean active) {
        ToroProfile profile = (ToroProfile)((WebClient.RequestBodySpec)this._webClient.put().uri(this.getScimUsersUri(id, tenantId))).bodyValue(Map.of("email", email, "firstName", firstName, "lastName", lastName, "active", active)).retrieve().bodyToMono(ToroProfile.class).onErrorMap(t -> new IllegalStateException(t.getMessage(), (Throwable)t)).block();
        return (ToroProfile)ObjectUtil.requireNonNull((Object)profile, (String)"Toro did not return a profile");
    }

    public void deleteProfile(ProfileId id, TenantId tenantId) {
        this._webClient.delete().uri(this.getScimUsersUri(id, tenantId)).retrieve().toBodilessEntity().onErrorMap(t -> new IllegalStateException(t.getMessage(), (Throwable)t)).block();
    }

    @Nonnull
    private URI getScimUsersUri(TenantId tenantId) {
        return this.getScimUsersUri(null, tenantId);
    }

    @Nonnull
    private URI getScimUsersUri(@Nullable ProfileId id, TenantId tenantId) {
        return UriComponentsBuilder.fromHttpUrl((String)(this._toroUrl + "/internal/profile/scim/users")).pathSegment(new String[]{id == null ? "" : id.toString()}).queryParam("tenantId", new Object[]{tenantId.toString()}).encode(StandardCharsets.UTF_8).build().toUri();
    }
}

