/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.security.JustAuthenticationManager;
import de.justsoftware.gateway.security.ToroOpaqueTokenIntrospector;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtIssuerReactiveAuthenticationManagerResolver;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenReactiveAuthenticationManager;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.server.authentication.ServerBearerTokenAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
public class JustAuthenticationManagerResolver
implements ReactiveAuthenticationManagerResolver<ServerWebExchange> {
    private static final int MAX_OPAQUE_TOKEN_LENGTH = 36;
    private final JwtIssuerReactiveAuthenticationManagerResolver _issuerResolverDelegate;
    private final JustAuthenticationManager _justAuthenticationManager;
    private final ReactiveAuthenticationManager _toroTokenManager;
    private final ServerAuthenticationConverter _tokenConverter = new ServerBearerTokenAuthenticationConverter();

    public JustAuthenticationManagerResolver(ReactiveAuthenticationManagerResolver<String> issuerAuthenticationManagerResolver, JustAuthenticationManager justAuthenticationManager, ToroOpaqueTokenIntrospector toroOpaqueTokenIntrospector) {
        this._issuerResolverDelegate = new JwtIssuerReactiveAuthenticationManagerResolver(issuerAuthenticationManagerResolver);
        this._justAuthenticationManager = justAuthenticationManager;
        this._toroTokenManager = new OpaqueTokenReactiveAuthenticationManager((ReactiveOpaqueTokenIntrospector)toroOpaqueTokenIntrospector);
    }

    public Mono<ReactiveAuthenticationManager> resolve(ServerWebExchange exchange) {
        return Mono.justOrEmpty(authentiation -> this._tokenConverter.convert(exchange).filter(BearerTokenAuthenticationToken.class::isInstance).cast(BearerTokenAuthenticationToken.class).map(BearerTokenAuthenticationToken::getToken).flatMap(token -> token.length() > 36 ? this._issuerResolverDelegate.resolve(exchange) : Mono.just((Object)this._toroTokenManager)).flatMap(tokenManager -> tokenManager.authenticate(authentiation).flatMap(arg_0 -> ((JustAuthenticationManager)this._justAuthenticationManager).authenticate(arg_0))));
    }
}

