/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.business.document.CycleFoundException;
import de.justsoftware.drive.business.document.NameValidation;
import de.justsoftware.drive.business.document.NotSameItemException;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileInfo;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface BaseDocumentTreeModificationService {
    @Nonnull
    public FolderVersionBO addSubFolder(DocumentId var1, String var2, PersonId var3);

    @Nonnull
    public ImmutableMap<DocumentVersionId, ByteSourceWithFilename> addFiles(DocumentId var1, Iterable<ByteSourceWithFilename> var2, PersonId var3, @Nullable String var4, NameValidation var5);

    @Nonnull
    public DocumentVersionId addEmptyFile(DocumentId var1, String var2, PersonId var3, @Nullable String var4, NameValidation var5);

    @Nonnull
    public ImmutableMap<StorageId, FileVersionBO> addFileInfos(DocumentId var1, Iterable<FileInfo> var2, PersonId var3, @Nullable String var4);

    public void createRootFolders(Map<ItemId, PersonId> var1, @Nullable String var2);

    @Nonnull
    public DocumentVersionId deleteDocument(DocumentId var1, PersonId var2);

    @Nonnull
    public FileVersionBO renameFile(DocumentId var1, PersonId var2, String var3);

    @Nonnull
    public FolderVersionBO renameFolder(DocumentId var1, PersonId var2, String var3);

    @Nonnull
    public ImmutableListMultimap<DocumentId, FileVersionBO> rollbackFiles(Set<DocumentId> var1);

    @Nonnull
    public FileVersionBO uploadNewFileVersion(DocumentId var1, ByteSourceWithFilename var2, PersonId var3, @Nullable String var4);

    @CheckForNull
    public ChangeBO restoreVersion(DocumentVersionId var1, PersonId var2, @Nullable String var3);

    public void moveToFolder(DocumentId var1, Set<DocumentId> var2, PersonId var3) throws NotSameItemException, CycleFoundException;

    public void copyToFolder(DocumentId var1, Map<DocumentId, PublishedFilter> var2, PersonId var3);
}

