/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.config;

import de.justsoftware.drive.business.search.SolrClientFactory;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableScheduling
@ParametersAreNonnullByDefault
public class DriveBatchProcessingConfiguration {
    @Autowired
    private SolrClientFactory _solrClientFactory;
    private SolrClient _writeSolrClient;

    @Bean
    @Nonnull
    public TaskScheduler changeMergeJobTaskScheduler() {
        ThreadPoolTaskScheduler defaultManagedTaskScheduler = new ThreadPoolTaskScheduler();
        defaultManagedTaskScheduler.setPoolSize(1);
        return defaultManagedTaskScheduler;
    }

    @Bean
    @Nonnull
    public SolrClient writeSolrClient(@Value(value="${just.drive.solr.writeUrl}") String writeSolrUrl) {
        return this._solrClientFactory.createSolrClient(writeSolrUrl);
    }

    @PreDestroy
    public void destroy() throws IOException {
        this._writeSolrClient.close();
    }
}

