/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.presentation.util;

import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentInfo;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.presentation.util.ExternalMessageFactory;
import de.justsoftware.jdoc.rest.exceptions.DocumentRepositoryAPIException;
import de.justsoftware.jdoc.rest.model.ExternalDocumentId;
import de.justsoftware.jdoc.rest.model.ExternalDocumentStatus;
import de.justsoftware.jdoc.rest.model.ExternalServiceInfo;
import de.justsoftware.jdoc.rest.model.message.DocumentStatusResponse;
import de.justsoftware.jdoc.rest.model.message.ServiceInfoResponse;
import de.justsoftware.jdoc.rest.service.shared.JustDocumentsApiService;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class ExternalMessageFactory {
    @Nonnull
    private static ExternalDocumentId createExternalDocumentId(DocumentId documentId) {
        return new ExternalDocumentId(documentId.toString());
    }

    @Nonnull
    private static ExternalDocumentStatus transform(DocumentInfo document, DocumentType type) throws DocumentRepositoryAPIException {
        DocumentStatus status = document.getDocumentStatus(type);
        switch (2.$SwitchMap$de$justsoftware$jdoc$model$DocumentStatus[status.ordinal()]) {
            case 1: {
                return ExternalDocumentStatus.PRESENT;
            }
            case 2: {
                return DocumentType.ORIGINAL.equals((Object)type) ? ExternalDocumentStatus.NOT_PRESENT : ExternalDocumentStatus.QUEUED;
            }
            case 3: {
                return ExternalDocumentStatus.ERROR;
            }
            case 4: {
                return ExternalDocumentStatus.CLEANED_UP;
            }
            case 5: {
                return ExternalDocumentStatus.PROCESSING;
            }
            case 6: {
                return ExternalDocumentStatus.QUEUED;
            }
            case 7: {
                return ExternalDocumentStatus.UNSUPPORTED;
            }
        }
        throw new DocumentRepositoryAPIException("No external status for internal one : " + status);
    }

    @Nonnull
    public static ExternalServiceInfo createServiceInfo(String name, boolean available, String version, String location) {
        return new ExternalServiceInfo(name, available, version, location);
    }

    @Nonnull
    public static ServiceInfoResponse createServiceInfoResponse(Collection<JustDocumentsApiService> services) {
        return new ServiceInfoResponse(services.stream().map(JustDocumentsApiService::getServiceInfo).collect(Collectors.toList()));
    }

    @Nonnull
    public static DocumentStatusResponse createDocumentStatusResponse(DocumentInfo documentInfo) throws DocumentRepositoryAPIException {
        return new DocumentStatusResponse(ExternalMessageFactory.createExternalDocumentId((DocumentId)documentInfo.getDocumentId()), ExternalMessageFactory.transform((DocumentInfo)documentInfo, (DocumentType)DocumentType.ORIGINAL), ExternalMessageFactory.transform((DocumentInfo)documentInfo, (DocumentType)DocumentType.PDF), ExternalMessageFactory.transform((DocumentInfo)documentInfo, (DocumentType)DocumentType.HTML));
    }

    @Nonnull
    public static InputStreamResource createDocumentStreamResourceResponse(DocumentInputStream documentStream) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    public static ResponseEntity<Resource> createResponseEntity(DocumentInputStream documentStream) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("content-type", documentStream.getContentType());
        headers.setContentLength(documentStream.getSize());
        return new ResponseEntity((Object)ExternalMessageFactory.createDocumentStreamResourceResponse((DocumentInputStream)documentStream), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }
}

