/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.actuator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.justsoftware.jdoc.services.monitoring.ResettableHealthIndicator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.shaded.com.google.common.base.Functions;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@Endpoint(id="monitoringQueueReset")
@ParametersAreNonnullByDefault
public class HealthResetEndpoint {
    private final ImmutableMap<String, ResettableHealthIndicator> _healtIndicators;

    public HealthResetEndpoint(ApplicationContext appContext) {
        String[] beanNamesForType = appContext.getBeanNamesForType(ResettableHealthIndicator.class);
        this._healtIndicators = (ImmutableMap)Arrays.stream(beanNamesForType).collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), name -> (ResettableHealthIndicator)appContext.getBean(name, ResettableHealthIndicator.class)));
    }

    @Nonnull
    @WriteOperation
    public Map<String, Object> reset() {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("cleared monitoring queues", this._healtIndicators.entrySet().stream().map(entry -> {
            ((ResettableHealthIndicator)entry.getValue()).resetStatus();
            return (String)entry.getKey();
        }).collect(Collectors.toList()));
        return resultMap;
    }
}

