/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.config.DriveFileUploadConfigProperties;
import de.justsoftware.chat.config.UpdatableMultipartConfigElement;
import jakarta.servlet.MultipartConfigElement;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/chat/config/MultipartConfiguration;", "", "multipartProperties", "Lorg/springframework/boot/autoconfigure/web/servlet/MultipartProperties;", "driveFileUploadConfigProperties", "Lde/justsoftware/chat/config/DriveFileUploadConfigProperties;", "(Lorg/springframework/boot/autoconfigure/web/servlet/MultipartProperties;Lde/justsoftware/chat/config/DriveFileUploadConfigProperties;)V", "multipartConfigElement", "Ljakarta/servlet/MultipartConfigElement;", "chat-service"})
public class MultipartConfiguration {
    @NotNull
    private final MultipartProperties multipartProperties;
    @NotNull
    private final DriveFileUploadConfigProperties driveFileUploadConfigProperties;

    public MultipartConfiguration(@NotNull MultipartProperties multipartProperties, @NotNull DriveFileUploadConfigProperties driveFileUploadConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)multipartProperties, (String)"multipartProperties");
        Intrinsics.checkNotNullParameter((Object)driveFileUploadConfigProperties, (String)"driveFileUploadConfigProperties");
        this.multipartProperties = multipartProperties;
        this.driveFileUploadConfigProperties = driveFileUploadConfigProperties;
    }

    @Bean
    @RefreshScope
    @Nonnull
    @NotNull
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigElement multipartConfigElement = this.multipartProperties.createMultipartConfig();
        return (MultipartConfigElement)new UpdatableMultipartConfigElement(multipartConfigElement.getLocation(), this.driveFileUploadConfigProperties.getUploadMaxFileSize(), multipartConfigElement.getFileSizeThreshold());
    }
}

