/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.model.ChatReadDate;
import de.justsoftware.chat.business.model.ChatReadDateAndCount;
import de.justsoftware.chat.business.model.UserChatUnreadCount;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatProfileId;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.persistence.ChatReadDateRepository;
import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbChatReadDate;
import de.justsoftware.chat.persistence.model.DbChatReadDateAndCount;
import de.justsoftware.chat.persistence.model.DbUserChatUnreadCount;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 02\u00020\u0001:\u00010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011H\u0016J*\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0016J2\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\b\b\u0002\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010&\u001a\u00020\u000fH\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0(2\u0006\u0010)\u001a\u00020\"H\u0016J \u0010*\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u0015H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000bH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/chat/business/ChatReadDateService;", "", "chatReadDateRepository", "Lde/justsoftware/chat/persistence/ChatReadDateRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "(Lde/justsoftware/chat/persistence/ChatReadDateRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/util/TransactionUtils;)V", "findByChatIdAndProfileId", "Ljava/util/Optional;", "Lde/justsoftware/chat/business/model/ChatReadDate;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "findChatIdsWithUpdatedReadDateSince", "", "participantIds", "Lde/justsoftware/chat/model/ParticipantId;", "readSince", "Ljava/time/Instant;", "getChatReadDates", "", "Lde/justsoftware/chat/model/ChatProfileId;", "ids", "getReadData", "Lde/justsoftware/chat/business/model/ChatReadDateAndCount;", "chatIds", "getUnreadCountsForUsers", "", "Lde/justsoftware/chat/business/model/UserChatUnreadCount;", "profileIds", "includeMarkedAsUnread", "", "getUnreadMessageCount", "", "chats", "currentProfileId", "getUsersEligibleForUnreadMail", "Ljava/util/stream/Stream;", "sendMailNotificationDefault", "markAsRead", "readDate", "markAsUnread", "", "save", "chatReadDate", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatReadDateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatReadDateService.kt\nde/justsoftware/chat/business/ChatReadDateService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n*L\n1#1,188:1\n1549#2:189\n1620#2,3:190\n1179#2,2:193\n1253#2,4:195\n1549#2:199\n1620#2,3:200\n1179#2,2:203\n1253#2,2:205\n1549#2:207\n1620#2,3:208\n1256#2:211\n1549#2:213\n1620#2,3:214\n1549#2:217\n1620#2,3:218\n1620#2,3:222\n1549#2:225\n1620#2,3:226\n1549#2:229\n1620#2,3:230\n1179#2,2:233\n1253#2,4:235\n1#3:212\n7#4:221\n*S KotlinDebug\n*F\n+ 1 ChatReadDateService.kt\nde/justsoftware/chat/business/ChatReadDateService\n*L\n85#1:189\n85#1:190,3\n87#1:193,2\n87#1:195,4\n96#1:199\n96#1:200,3\n98#1:203,2\n98#1:205,2\n100#1:207\n100#1:208,3\n98#1:211\n107#1:213\n107#1:214,3\n120#1:217\n120#1:218,3\n124#1:222,3\n133#1:225\n133#1:226,3\n134#1:229\n134#1:230,3\n135#1:233,2\n135#1:235,4\n124#1:221\n*E\n"})
public class ChatReadDateService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatReadDateRepository chatReadDateRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final TransactionUtils transactionUtils;

    public ChatReadDateService(@NotNull ChatReadDateRepository chatReadDateRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull TransactionUtils transactionUtils) {
        Intrinsics.checkNotNullParameter((Object)chatReadDateRepository, (String)"chatReadDateRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        this.chatReadDateRepository = chatReadDateRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.transactionUtils = transactionUtils;
    }

    @NotNull
    public ChatReadDate markAsRead(@NotNull ChatId chatId, @NotNull ProfileId profileId, @NotNull Instant readDate) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)readDate, (String)"readDate");
        ChatReadDate chatReadDate = this.findByChatIdAndProfileId(chatId, profileId).map(arg_0 -> ChatReadDateService.markAsRead$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).orElseGet(() -> ChatReadDateService.markAsRead$lambda$1(this, chatId, profileId, readDate));
        Intrinsics.checkNotNullExpressionValue((Object)chatReadDate, (String)"fun markAsRead(\n        \u2026lse))\n            }\n    }");
        return chatReadDate;
    }

    public void markAsUnread(@NotNull ChatId chatId, @NotNull ProfileId profileId) {
        ChatReadDate chatReadDate;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Optional optional = this.findByChatIdAndProfileId(chatId, profileId);
        Instant instant = Instant.ofEpochMilli(0L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(0)");
        Instant readDate = optional.orElse(new ChatReadDate(chatId, profileId, instant, true, null, 16, null)).getReadDate();
        Object object = this.chatReadDateRepository.save((Object)DbChatReadDate.Companion.toDbChatReadDate(new ChatReadDate(chatId, profileId, readDate, true, null, 16, null)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatReadDateRepository\n \u2026true).toDbChatReadDate())");
        ChatReadDate savedChatReadDate = chatReadDate = DbChatReadDate.Companion.toChatReadDate((DbChatReadDate)object);
        boolean bl = false;
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, ChatReadDateAndCount> getReadData(@NotNull ProfileId profileId, @NotNull Set<ChatId> chatIds2) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Iterable iterable = chatIds2;
        ChatReadDateRepository chatReadDateRepository = this.chatReadDateRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        Iterable $this$associate$iv = chatReadDateRepository.readDateAndCountForUserInChats((Iterable)((List)destination$iv$iv), profileId.toCanonicalId()).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID chatId = (UUID)entry.getKey();
            DbChatReadDateAndCount dbChatReadDataResult = (DbChatReadDateAndCount)entry.getValue();
            entry = TuplesKt.to((Object)new ChatId(chatId), (Object)DbChatReadDateAndCount.Companion.toChatReadDateAndCount(dbChatReadDataResult));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, List<UserChatUnreadCount>> getUnreadCountsForUsers(@NotNull Set<ProfileId> profileIds, boolean includeMarkedAsUnread) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        ChatReadDateRepository chatReadDateRepository = this.chatReadDateRepository;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$associate$iv = chatReadDateRepository.unreadCountsForUsers((Iterable)((List)destination$iv$iv)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            ProfileId profileId = ProfileId.Companion.fromCanonicalId(key);
            Iterable $this$map$iv2 = value;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbUserChatUnreadCount dbUserChatUnreadCount = (DbUserChatUnreadCount)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(DbUserChatUnreadCount.Companion.toUserChatUnreadCount((DbUserChatUnreadCount)it));
            }
            List unreadCounts = (List)destination$iv$iv3;
            entry = TuplesKt.to((Object)profileId, (Object)unreadCounts);
            map.put(entry.getFirst(), entry.getSecond());
        }
        Map counts = destination$iv$iv2;
        boolean bl = false;
        return includeMarkedAsUnread ? counts : Companion.access$filterUnread((Companion)Companion, (Map)counts);
    }

    public static /* synthetic */ Map getUnreadCountsForUsers$default(ChatReadDateService chatReadDateService, Set set, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUnreadCountsForUsers");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return chatReadDateService.getUnreadCountsForUsers(set, bl);
    }

    /*
     * WARNING - void declaration
     */
    public int getUnreadMessageCount(@NotNull Set<ChatId> chats2, @NotNull ProfileId currentProfileId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chats2, (String)"chats");
        Intrinsics.checkNotNullParameter((Object)currentProfileId, (String)"currentProfileId");
        Iterable iterable = chats2;
        ChatReadDateRepository chatReadDateRepository = this.chatReadDateRepository;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        iterable = chatReadDateRepository.readDateAndCountForUserInChats((Iterable)((List)destination$iv$iv), currentProfileId.toCanonicalId()).values();
        long l = 0L;
        for (Object t : iterable) {
            void it;
            DbChatReadDateAndCount dbChatReadDateAndCount = (DbChatReadDateAndCount)t;
            long l2 = l;
            boolean bl = false;
            long l3 = DbChatReadDateAndCount.Companion.toChatReadDateAndCount((DbChatReadDateAndCount)it).getUnreadOrMarkedCount();
            l = l2 + l3;
        }
        return (int)l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findChatIdsWithUpdatedReadDateSince(@NotNull Set<? extends ParticipantId> participantIds, @NotNull Instant readSince, @NotNull ProfileId profileId) {
        void $this$mapToSet$iv;
        UUID p0;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)readSince, (String)"readSince");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Iterable iterable = participantIds;
        Object object = this.chatReadDateRepository;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        $this$map$iv = object.findChatsByUpdatedAtGreaterThanAndParticipantIds((Iterable)((List)destination$iv$iv), readSince, profileId.toCanonicalId());
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (UUID)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new ChatId(p0));
        }
        return (Set)destination$iv$iv;
    }

    @NotNull
    public Stream<ProfileId> getUsersEligibleForUnreadMail(boolean sendMailNotificationDefault) {
        Stream<ProfileId> stream = this.chatReadDateRepository.usersEligibleForUnreadMail(sendMailNotificationDefault).map(arg_0 -> ChatReadDateService.getUsersEligibleForUnreadMail$lambda$12((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"chatReadDateRepository\n \u2026mpanion::fromCanonicalId)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatProfileId, Instant> getChatReadDates(@NotNull Set<ChatProfileId> ids) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable iterable = ids;
        Object object = this.chatReadDateRepository;
        boolean $i$f$map22 = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            ChatProfileId chatProfileId = (ChatProfileId)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DbChatProfileId(it.getChatId(), it.getProfileId()));
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"chatReadDateRepository\n \u2026.chatId, it.profileId) })");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (DbChatReadDate)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            object.add(DbChatReadDate.Companion.toChatReadDate((DbChatReadDate)it));
        }
        Iterable $this$associate$iv = (List)destination$iv$iv2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv22;
            ChatReadDate it = (ChatReadDate)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)new ChatProfileId(it.getChatId(), it.getProfileId()), (Object)it.getReadDate());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv22;
    }

    private ChatReadDate save(ChatReadDate chatReadDate) {
        ChatReadDate chatReadDate2;
        Object object = this.chatReadDateRepository.save((Object)DbChatReadDate.Companion.toDbChatReadDate(chatReadDate));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatReadDateRepository\n \u2026dDate.toDbChatReadDate())");
        ChatReadDate savedChatReadDate = chatReadDate2 = DbChatReadDate.Companion.toChatReadDate((DbChatReadDate)object);
        boolean bl = false;
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return chatReadDate2;
    }

    private Optional<ChatReadDate> findByChatIdAndProfileId(ChatId chatId, ProfileId profileId) {
        Optional<ChatReadDate> optional = this.chatReadDateRepository.findById((Object)new DbChatProfileId(chatId, profileId)).map(arg_0 -> ChatReadDateService.findByChatIdAndProfileId$lambda$17((Function1)findByChatIdAndProfileId.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"chatReadDateRepository\n \u2026p { it.toChatReadDate() }");
        return optional;
    }

    private static final ChatReadDate markAsRead$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatReadDate)$tmp0.invoke(p0);
    }

    private static final ChatReadDate markAsRead$lambda$1(ChatReadDateService this$0, ChatId $chatId, ProfileId $profileId, Instant $readDate) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        Intrinsics.checkNotNullParameter((Object)$profileId, (String)"$profileId");
        Intrinsics.checkNotNullParameter((Object)$readDate, (String)"$readDate");
        return this$0.save(new ChatReadDate($chatId, $profileId, $readDate, false, null, 16, null));
    }

    private static final ProfileId getUsersEligibleForUnreadMail$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProfileId)$tmp0.invoke(p0);
    }

    private static final ChatReadDate findByChatIdAndProfileId$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatReadDate)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ChatReadDate access$save(ChatReadDateService $this, ChatReadDate chatReadDate) {
        return $this.save(chatReadDate);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ChatReadDateService $this) {
        return $this.applicationEventPublisher;
    }
}

