/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher.producer;

import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.id.ItemId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.kafka.publisher.model.KafkaPublishOperation;
import de.justsoftware.admin.kafka.publisher.producer.PermissionProducer;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u0000 <2\u00020\u0001:\u0001<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\u001b\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0010\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J\u001b\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0010\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b*J\u001b\u0010+\u001a\u00020\r2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-H\u0010\u00a2\u0006\u0002\b.J#\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u0002012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-H\u0010\u00a2\u0006\u0002\b2J\u001b\u00103\u001a\u00020\r2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-H\u0010\u00a2\u0006\u0002\b4J\u001b\u00105\u001a\u00020\b2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0010\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b9J\u001b\u0010:\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0010\u00a2\u0006\u0002\b;R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lde/justsoftware/admin/kafka/publisher/producer/PermissionProducer;", "", "permissionItemProducer", "Lde/justsoftware/permission/client/kafka/PermissionItemProducer;", "singleRoleAssignmentProducer", "Lde/justsoftware/permission/client/kafka/SingleRoleAssignmentProducer;", "(Lde/justsoftware/permission/client/kafka/PermissionItemProducer;Lde/justsoftware/permission/client/kafka/SingleRoleAssignmentProducer;)V", "allowMembersToReadTenant", "Lde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "allowMembersToReadTenant$admin_service", "allowUserGroupToReadTenant", "", "userGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "allowUserGroupToReadTenant$admin_service", "applyAppPermissions", "addedPermissions", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "applyAppPermissions$admin_service", "applyTenantPermission", "tenantPermission", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "applyTenantPermission$admin_service", "applyTenantPermissions", "tenantPermissions", "applyTenantPermissions$admin_service", "deleteAllAppsForTenant", "deleteAllAppsForTenant$admin_service", "deleteItem", "itemId", "Lde/justsoftware/admin/id/ItemId;", "deleteItem$admin_service", "disallowMembersToReadTenant", "disallowMembersToReadTenant$admin_service", "disallowUserGroupToReadTenant", "disallowUserGroupToReadTenant$admin_service", "registerCoreAppsForTenant", "registerCoreAppsForTenant$admin_service", "registerTenant", "registerTenant$admin_service", "republishAppRoles", "doRepublish", "Lkotlin/Function0;", "republishAppRoles$admin_service", "republishItems", "itemType", "Lde/justsoftware/admin/id/ItemId$Type;", "republishItems$admin_service", "republishTenantRoles", "republishTenantRoles$admin_service", "revokeAppPermissions", "deletedPermissions", "revokeAppPermissions$admin_service", "revokeTenantPermission", "revokeTenantPermission$admin_service", "revokeTenantPermissions", "revokeTenantPermissions$admin_service", "Companion", "admin-service"})
@SourceDebugExtension(value={"SMAP\nPermissionProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionProducer.kt\nde/justsoftware/admin/kafka/publisher/producer/PermissionProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1549#2:240\n1620#2,3:241\n1549#2:244\n1620#2,3:245\n1549#2:248\n1620#2,3:249\n1549#2:252\n1620#2,3:253\n1549#2:256\n1620#2,3:257\n1549#2:260\n1620#2,3:261\n1549#2:264\n1620#2,3:265\n1549#2:268\n1620#2,3:269\n*S KotlinDebug\n*F\n+ 1 PermissionProducer.kt\nde/justsoftware/admin/kafka/publisher/producer/PermissionProducer\n*L\n69#1:240\n69#1:241,3\n75#1:244\n75#1:245,3\n90#1:248\n90#1:249,3\n91#1:252\n91#1:253,3\n121#1:256\n121#1:257,3\n144#1:260\n144#1:261,3\n172#1:264\n172#1:265,3\n192#1:268\n192#1:269,3\n*E\n"})
public class PermissionProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionItemProducer permissionItemProducer;
    @NotNull
    private final SingleRoleAssignmentProducer singleRoleAssignmentProducer;

    public PermissionProducer(@NotNull PermissionItemProducer permissionItemProducer, @NotNull SingleRoleAssignmentProducer singleRoleAssignmentProducer) {
        Intrinsics.checkNotNullParameter((Object)permissionItemProducer, (String)"permissionItemProducer");
        Intrinsics.checkNotNullParameter((Object)singleRoleAssignmentProducer, (String)"singleRoleAssignmentProducer");
        this.permissionItemProducer = permissionItemProducer;
        this.singleRoleAssignmentProducer = singleRoleAssignmentProducer;
    }

    @NotNull
    public KafkaPublishOperation registerTenant$admin_service(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishItem(tenantId.toTypedString(), Optional.empty(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"publishItem(...)");
        return new KafkaPublishOperation(waitForOffsets);
    }

    @NotNull
    public KafkaPublishOperation registerCoreAppsForTenant$admin_service(@NotNull TenantId tenantId) {
        WaitForOffsets it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$map$iv = (Iterable)CoreApp.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CoreApp coreApp = (CoreApp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.permissionItemProducer.publishItem(it.asItemId(tenantId), Optional.of(tenantId.toTypedString()), new String[0]));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WaitForOffsets)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new KafkaPublishOperation(it));
        }
        List ops = (List)destination$iv$iv;
        return new KafkaPublishOperation(ops);
    }

    @NotNull
    public KafkaPublishOperation deleteItem$admin_service(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishDeletedItem(itemId.toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"publishDeletedItem(...)");
        return new KafkaPublishOperation(waitForOffsets);
    }

    @NotNull
    public KafkaPublishOperation deleteAllAppsForTenant$admin_service(@NotNull TenantId tenantId) {
        WaitForOffsets it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$map$iv = (Iterable)CoreApp.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CoreApp coreApp = (CoreApp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.permissionItemProducer.publishDeletedItem(it.asItemId(tenantId)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WaitForOffsets)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new KafkaPublishOperation(it));
        }
        List ops = (List)destination$iv$iv;
        return new KafkaPublishOperation(ops);
    }

    @NotNull
    public KafkaPublishOperation allowMembersToReadTenant$admin_service(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        WaitForOffsets waitForOffsets = this.singleRoleAssignmentProducer.addRoleReplacement(Role.reader((String)tenantId.toTypedString()), Role.tenantRole((UUID)tenantId.getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"addRoleReplacement(...)");
        WaitForOffsets waitForOffsets2 = waitForOffsets;
        return new KafkaPublishOperation(waitForOffsets2);
    }

    public void allowUserGroupToReadTenant$admin_service(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.singleRoleAssignmentProducer.addRoleReplacement(Role.reader((String)userGroup.getTenantId().toTypedString()), Role.userGroupRole((UUID)userGroup.getId().getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation applyAppPermissions$admin_service(@NotNull Collection<AppPermission> addedPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(addedPermissions, (String)"addedPermissions");
        Iterable $this$map$iv = CollectionsKt.toSet((Iterable)addedPermissions);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppPermission appPermission = (AppPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.singleRoleAssignmentProducer.addRoleReplacement(Companion.access$getPermissionClientRole((Companion)Companion, (AppPermission)it), Role.create((String)it.getGranteeId().toTypedString())));
        }
        Stream stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        Stream waitForOffsetsStream = stream;
        return new KafkaPublishOperation(waitForOffsetsStream);
    }

    @NotNull
    public KafkaPublishOperation applyTenantPermission$admin_service(@NotNull TenantPermission tenantPermission) {
        Intrinsics.checkNotNullParameter((Object)tenantPermission, (String)"tenantPermission");
        Role role = Role.create((String)tenantPermission.getGranteeId().toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"create(...)");
        Role granteeRole = role;
        Role grantedRole = Companion.access$getPermissionClientRole((Companion)Companion, (TenantPermission)tenantPermission);
        WaitForOffsets waitForOffsets = this.singleRoleAssignmentProducer.addRoleReplacement(grantedRole, granteeRole);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"addRoleReplacement(...)");
        WaitForOffsets waitForOffsets2 = waitForOffsets;
        return new KafkaPublishOperation(waitForOffsets2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation applyTenantPermissions$admin_service(@NotNull Collection<TenantPermission> tenantPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tenantPermissions, (String)"tenantPermissions");
        Iterable $this$map$iv = CollectionsKt.toSet((Iterable)tenantPermissions);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.applyTenantPermission$admin_service((TenantPermission)it));
        }
        List waitForOffsetList = (List)destination$iv$iv;
        return new KafkaPublishOperation(waitForOffsetList);
    }

    @NotNull
    public KafkaPublishOperation disallowMembersToReadTenant$admin_service(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        WaitForOffsets waitForOffsets = this.singleRoleAssignmentProducer.deleteRoleReplacement(Role.reader((String)tenantId.toTypedString()), Role.tenantRole((UUID)tenantId.getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"deleteRoleReplacement(...)");
        WaitForOffsets waitForOffsets2 = waitForOffsets;
        return new KafkaPublishOperation(waitForOffsets2);
    }

    @NotNull
    public KafkaPublishOperation disallowUserGroupToReadTenant$admin_service(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        WaitForOffsets waitForOffsets = this.singleRoleAssignmentProducer.deleteRoleReplacement(Role.reader((String)userGroup.getTenantId().toTypedString()), Role.userGroupRole((UUID)userGroup.getId().getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"deleteRoleReplacement(...)");
        WaitForOffsets waitForOffsets2 = waitForOffsets;
        return new KafkaPublishOperation(waitForOffsets2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation revokeAppPermissions$admin_service(@NotNull Collection<AppPermission> deletedPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletedPermissions, (String)"deletedPermissions");
        Iterable $this$map$iv = CollectionsKt.toSet((Iterable)deletedPermissions);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppPermission appPermission = (AppPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.singleRoleAssignmentProducer.deleteRoleReplacement(Companion.access$getPermissionClientRole((Companion)Companion, (AppPermission)it), Role.create((String)it.getGranteeId().toTypedString())));
        }
        Stream stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        Stream waitForOffsetsStream = stream;
        return new KafkaPublishOperation(waitForOffsetsStream);
    }

    @NotNull
    public KafkaPublishOperation revokeTenantPermission$admin_service(@NotNull TenantPermission tenantPermission) {
        Intrinsics.checkNotNullParameter((Object)tenantPermission, (String)"tenantPermission");
        Role grantedRole = Companion.access$getPermissionClientRole((Companion)Companion, (TenantPermission)tenantPermission);
        Role role = Role.create((String)tenantPermission.getGranteeId().toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"create(...)");
        Role granteeRole = role;
        WaitForOffsets waitForOffsets = this.singleRoleAssignmentProducer.deleteRoleReplacement(grantedRole, granteeRole);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"deleteRoleReplacement(...)");
        WaitForOffsets waitForOffsets2 = waitForOffsets;
        return new KafkaPublishOperation(waitForOffsets2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation revokeTenantPermissions$admin_service(@NotNull Collection<TenantPermission> tenantPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tenantPermissions, (String)"tenantPermissions");
        Iterable $this$map$iv = tenantPermissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.revokeTenantPermission$admin_service((TenantPermission)it));
        }
        List waitForOffsets = (List)destination$iv$iv;
        return new KafkaPublishOperation(waitForOffsets);
    }

    public void republishItems$admin_service(@NotNull ItemId.Type itemType, @NotNull Function0<Unit> doRepublish) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
        Intrinsics.checkNotNullParameter(doRepublish, (String)"doRepublish");
        this.permissionItemProducer.republish(itemType.name(), () -> PermissionProducer.republishItems$lambda$8(doRepublish));
    }

    public void republishTenantRoles$admin_service(@NotNull Function0<Unit> doRepublish) {
        Intrinsics.checkNotNullParameter(doRepublish, (String)"doRepublish");
        Object[] objectArray = new String[]{"READER", "WRITER", "MANAGER"};
        this.singleRoleAssignmentProducer.republishForItemRoles(ItemId.Type.TENANT.toString(), SetsKt.setOf((Object[])objectArray), () -> PermissionProducer.republishTenantRoles$lambda$9(doRepublish));
    }

    public void republishAppRoles$admin_service(@NotNull Function0<Unit> doRepublish) {
        Intrinsics.checkNotNullParameter(doRepublish, (String)"doRepublish");
        Object[] objectArray = new String[]{"READER", "WRITER", "MANAGER", "EXPORTER"};
        this.singleRoleAssignmentProducer.republishForItemRoles(ItemId.Type.APP.toString(), SetsKt.setOf((Object[])objectArray), () -> PermissionProducer.republishAppRoles$lambda$10(doRepublish));
    }

    private static final void republishItems$lambda$8(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void republishTenantRoles$lambda$9(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void republishAppRoles$lambda$10(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }
}

