/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.toro.ToroConnector;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.ApiToken;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.id.TenantId;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/ScimConfigFetcher;", "", "toroConnector", "Lde/justsoftware/admin/connector/toro/ToroConnector;", "tenantApplicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "(Lde/justsoftware/admin/connector/toro/ToroConnector;Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "deleteToken", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "generateToken", "token", "Lde/justsoftware/admin/graphql/generated/types/ApiToken;", "admin-service"})
public class ScimConfigFetcher {
    @NotNull
    private final ToroConnector toroConnector;
    @NotNull
    private final TenantApplicationService tenantApplicationService;

    public ScimConfigFetcher(@NotNull ToroConnector toroConnector, @NotNull TenantApplicationService tenantApplicationService) {
        Intrinsics.checkNotNullParameter((Object)toroConnector, (String)"toroConnector");
        Intrinsics.checkNotNullParameter((Object)tenantApplicationService, (String)"tenantApplicationService");
        this.toroConnector = toroConnector;
        this.tenantApplicationService = tenantApplicationService;
    }

    @DgsData(parentType="Tenant", field="scimToken")
    @Nullable
    public ApiToken token(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        return this.toroConnector.getScimToken(tenantId);
    }

    @DgsMutation(field="generateScimToken")
    @NotNull
    public Tenant generateToken(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        this.toroConnector.generateScimToken(tenantId);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="deleteScimToken")
    @NotNull
    public Tenant deleteToken(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        this.toroConnector.deleteScimToken(tenantId);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }
}

