/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.toro.ToroConnector;
import de.justsoftware.admin.domain.appsettings.AppSettingsPermissionService;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppPlacement;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.CoreAppPlacement;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.AppPlacementInput;
import de.justsoftware.admin.graphql.generated.types.CreateExternalAppInput;
import de.justsoftware.admin.graphql.generated.types.UpdateCoreAppInput;
import de.justsoftware.admin.graphql.generated.types.UpdateExternalAppInput;
import de.justsoftware.admin.id.AppId;
import de.justsoftware.admin.id.CoreAppId;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ExternalAppId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0012H\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010-\u001a\u00020\u000e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020,0\u00192\u0006\u0010\u0014\u001a\u00020\u0012H\u0017J\u0018\u0010/\u001a\u00020!2\u0006\u0010\u000f\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\u0012H\u0017J\u0018\u00101\u001a\u00020'2\u0006\u0010\u000f\u001a\u0002022\u0006\u0010\u0014\u001a\u00020\u0012H\u0017J,\u00103\u001a\u00020\u000e2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0014\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/justsoftware/admin/application/web/AppSettingsApplicationService;", "", "appSettingsPermissionService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "toroConnector", "Lde/justsoftware/admin/connector/toro/ToroConnector;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/connector/toro/ToroConnector;Lde/justsoftware/admin/application/util/TransactionSupport;)V", "createExternalApp", "", "input", "Lde/justsoftware/admin/graphql/generated/types/CreateExternalAppInput;", "authorizationContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "deleteAppHomeScreenPositionsOfUsers", "authContext", "deleteExternalApp", "id", "Lde/justsoftware/admin/id/ExternalAppId;", "getAppConfigs", "", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "getAppPermissions", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "getCoreAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "coreAppId", "Lde/justsoftware/admin/id/CoreAppId;", "getExternalAppDefaults", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$Companion$Defaults;", "getExternalAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "externalAppId", "getPlacements", "Lde/justsoftware/admin/domain/appsettings/model/AppPlacement;", "appId", "Lde/justsoftware/admin/id/AppId;", "updateAppPositions", "appIds", "updateCoreApp", "Lde/justsoftware/admin/graphql/generated/types/UpdateCoreAppInput;", "updateExternalApp", "Lde/justsoftware/admin/graphql/generated/types/UpdateExternalAppInput;", "updatePermissions", "adds", "removes", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsApplicationService.kt\nde/justsoftware/admin/application/web/AppSettingsApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1726#2,3:272\n1549#2:275\n1620#2,3:276\n1549#2:279\n1620#2,3:280\n1549#2:283\n1620#2,3:284\n1549#2:287\n1620#2,3:288\n1549#2:291\n1620#2,3:292\n1726#2,3:295\n1549#2:298\n1620#2,3:299\n1549#2:302\n1620#2,3:303\n1549#2:306\n1620#2,3:307\n800#2,11:310\n1726#2,3:321\n800#2,11:324\n1549#2:335\n1620#2,3:336\n1726#2,3:339\n*S KotlinDebug\n*F\n+ 1 AppSettingsApplicationService.kt\nde/justsoftware/admin/application/web/AppSettingsApplicationService\n*L\n53#1:272,3\n57#1:275\n57#1:276,3\n81#1:279\n81#1:280,3\n82#1:283\n82#1:284,3\n96#1:287\n96#1:288,3\n100#1:291\n100#1:292,3\n146#1:295,3\n170#1:298\n170#1:299,3\n214#1:302\n214#1:303,3\n215#1:306\n215#1:307,3\n248#1:310,11\n249#1:321,3\n252#1:324,11\n253#1:335\n253#1:336,3\n254#1:339,3\n*E\n"})
public class AppSettingsApplicationService {
    @NotNull
    private final AppSettingsPermissionService appSettingsPermissionService;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final ToroConnector toroConnector;
    @NotNull
    private final TransactionSupport transactionSupport;

    public AppSettingsApplicationService(@NotNull AppSettingsPermissionService appSettingsPermissionService, @NotNull AppSettingsService appSettingsService, @NotNull Publisher publisher, @NotNull ToroConnector toroConnector, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)appSettingsPermissionService, (String)"appSettingsPermissionService");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)toroConnector, (String)"toroConnector");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.appSettingsPermissionService = appSettingsPermissionService;
        this.appSettingsService = appSettingsService;
        this.publisher = publisher;
        this.toroConnector = toroConnector;
        this.transactionSupport = transactionSupport;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updatePermissions(@NotNull Set<AppPermission> adds, @NotNull Set<AppPermission> removes, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        Iterable $this$all$iv;
        Set appPermissions;
        block5: {
            Intrinsics.checkNotNullParameter(adds, (String)"adds");
            Intrinsics.checkNotNullParameter(removes, (String)"removes");
            Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
            TenantId tenantId = authContext.getNonNullTenantId();
            appPermissions = SetsKt.plus(adds, (Iterable)removes);
            $this$all$iv = appPermissions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AppPermission it = (AppPermission)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getTenantId(), (Object)tenantId)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-require-AppSettingsApplicationService$updatePermissions$32 = false;
            String $i$a$-require-AppSettingsApplicationService$updatePermissions$32 = "All AppPermissions need to be of the same Tenant.";
            throw new IllegalArgumentException($i$a$-require-AppSettingsApplicationService$updatePermissions$32.toString());
        }
        authContext.checkTenantManager();
        $this$all$iv = appPermissions;
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppPermission appPermission = (AppPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getGranteeId());
        }
        authorizationContext.checkAllTenantReader((Collection)((List)destination$iv$iv));
        this.appSettingsPermissionService.updatePermissions((Collection)adds, (Collection)removes);
        this.publisher.publishUpdatedAppPermissions((Collection)adds, (Collection)removes);
    }

    @NotNull
    public List<AppSettings> getAppConfigs(@NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager();
        TenantId tenantId = authorizationContext.getNonNullTenantId();
        return this.appSettingsService.getAppsByTenant(tenantId);
    }

    @NotNull
    public CoreAppSettings getCoreAppSettings(@NotNull CoreAppId coreAppId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)coreAppId, (String)"coreAppId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        TenantId tenantId = coreAppId.getTenantId();
        authorizationContext.checkTenantManager(tenantId);
        return this.appSettingsService.getCoreApp(coreAppId);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public CoreAppSettings updateCoreApp(@NotNull UpdateCoreAppInput input, @NotNull AuthorizationContext authContext) {
        Collection collection;
        Collection collection2;
        Iterable destination$iv$iv;
        List list;
        List list2;
        Iterable iterable;
        Iterable destination$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = input.getId().getTenantId();
        authContext.checkTenantManager(tenantId);
        List list3 = input.getPlacementAdds();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AppPlacementInput appPlacementInput = (AppPlacementInput)item$iv$iv;
                iterable = destination$iv$iv2;
                boolean bl = false;
                iterable.add(ModelConverterKt.toDomainCoreApp((AppPlacementInput)it, (CoreAppId)input.getId(), (TenantId)tenantId));
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = null;
        }
        List placementAdds = list2;
        List list4 = input.getPlacementRemoves();
        if (list4 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list4;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AppPlacementInput bl = (AppPlacementInput)item$iv$iv;
                iterable = destination$iv$iv3;
                boolean bl2 = false;
                iterable.add(ModelConverterKt.toDomainCoreApp((AppPlacementInput)it, (CoreAppId)input.getId(), (TenantId)tenantId));
            }
            list = (List)destination$iv$iv3;
        } else {
            list = null;
        }
        List placementRemoves = list;
        CoreAppSettings updatedApp = this.appSettingsService.updateCoreApp(input.getId(), authContext.getProfileId(), input.getActive(), input.getAppColor(), input.getHomeScreenAppColor(), input.getIconId(), input.getRemoveIcon(), placementAdds, placementRemoves);
        List list5 = placementAdds;
        if (list5 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list5;
            boolean $i$f$map = false;
            Iterable $i$f$mapTo = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CoreAppPlacement coreAppPlacement = (CoreAppPlacement)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl = false;
                iterable.add(new AppPermission(it.getTenantId(), it.getCoreApp(), it.getUserId(), Role.READER));
            }
            collection2 = (List)destination$iv$iv;
        } else {
            collection2 = SetsKt.emptySet();
        }
        Collection permissionAdds = collection2;
        List list6 = placementRemoves;
        if (list6 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list6;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CoreAppPlacement bl = (CoreAppPlacement)item$iv$iv;
                iterable = destination$iv$iv4;
                boolean bl3 = false;
                iterable.add(new AppPermission(it.getTenantId(), it.getCoreApp(), it.getUserId(), Role.READER));
            }
            collection = (List)destination$iv$iv4;
        } else {
            collection = SetsKt.emptySet();
        }
        Collection permissionRemoves = collection;
        this.appSettingsPermissionService.updatePermissions(permissionAdds, permissionRemoves);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return updatedApp;
    }

    @NotNull
    public ExternalAppSettings getExternalAppSettings(@NotNull ExternalAppId externalAppId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)externalAppId, (String)"externalAppId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ExternalAppSettings externalAppSettings = this.appSettingsService.getExternalApp(externalAppId);
        authContext.checkTenantManager(externalAppSettings.getTenantId());
        return externalAppSettings;
    }

    @NotNull
    public Set<AppPermission> getAppPermissions(@NotNull CoreApp app, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager();
        TenantId tenantId = authorizationContext.getNonNullTenantId();
        return this.appSettingsPermissionService.getPermissions(tenantId, app);
    }

    @NotNull
    public Set<AppPlacement> getPlacements(@NotNull AppId appId, @NotNull AuthorizationContext authorizationContext) {
        boolean bl;
        Set placements;
        block4: {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
            authorizationContext.checkTenantManager();
            placements = this.appSettingsService.getPlacements(appId);
            Iterable $this$all$iv = placements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AppPlacement it = (AppPlacement)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getTenantId(), (Object)authorizationContext.getNonNullTenantId())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Can only fetch AppPlacements of current Tenant.";
            throw new IllegalArgumentException(string.toString());
        }
        return placements;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void createExternalApp(@NotNull CreateExternalAppInput input, @NotNull AuthorizationContext authorizationContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager();
        TenantId tenantId = authorizationContext.getNonNullTenantId();
        ExternalAppSettings.Companion companion = ExternalAppSettings.Companion;
        boolean bl = input.getActive();
        List list = input.getClients();
        Object object = input.getIconId();
        String string = input.getName();
        HexColor hexColor = input.getHomeScreenAppColor();
        String string2 = input.getUrl();
        ExternalAppSettings.OpenUrlIn openUrlIn = input.getOpenUrlIn();
        int n = this.appSettingsService.getLastPosition(tenantId);
        ExternalAppSettings newSettings = ExternalAppSettings.Companion.withDefaults$default((ExternalAppSettings.Companion)companion, (String)string, (String)string2, (int)n, (TenantId)tenantId, (Collection)list, null, (boolean)bl, (DocumentId)object, (ExternalAppSettings.OpenUrlIn)openUrlIn, (HexColor)hexColor, (int)32, null);
        Iterable $this$map$iv = input.getPlacementAdds();
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppPlacementInput appPlacementInput = (AppPlacementInput)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new AppPlacement((AppId)newSettings.getId(), UserId.Companion.fromString(it.getUserId()), it.getType(), newSettings.getTenantId()));
        }
        Set placements = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.appSettingsService.createExternalApp(newSettings, (Collection)placements, authorizationContext.getProfileId());
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public ExternalAppSettings.Companion.Defaults getExternalAppDefaults(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        return ExternalAppSettings.Companion.Defaults.INSTANCE;
    }

    @Transactional
    @NotNull
    public ExternalAppSettings updateExternalApp(@NotNull UpdateExternalAppInput input, @NotNull AuthorizationContext authContext) {
        Collection<AppPlacement> collection;
        Collection collection2;
        AppPlacementInput it;
        Collection<AppPlacement> collection3;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        AppSettingsService appSettingsService;
        ExternalAppId externalAppId;
        ProfileId profileId;
        Boolean bl;
        Collection collection4;
        HexColor hexColor;
        DocumentId documentId;
        Boolean bl2;
        String string;
        String string2;
        ExternalAppSettings.OpenUrlIn openUrlIn;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ExternalAppSettings origin = this.appSettingsService.getExternalApp(input.getId());
        authContext.checkTenantManager(origin.getTenantId());
        AppSettingsService appSettingsService2 = this.appSettingsService;
        ExternalAppId externalAppId2 = input.getId();
        ProfileId profileId2 = authContext.getProfileId();
        Boolean bl3 = input.getActive();
        Collection collection5 = input.getClients();
        HexColor hexColor2 = input.getHomeScreenAppColor();
        DocumentId documentId2 = input.getIconId();
        Boolean bl4 = input.getRemoveIcon();
        String string3 = input.getName();
        String string4 = input.getUrl();
        ExternalAppSettings.OpenUrlIn openUrlIn2 = input.getOpenUrlIn();
        List list = input.getPlacementAdds();
        if (list != null) {
            Iterable iterable = list;
            openUrlIn = openUrlIn2;
            string2 = string4;
            string = string3;
            bl2 = bl4;
            documentId = documentId2;
            hexColor = hexColor2;
            collection4 = collection5;
            bl = bl3;
            profileId = profileId2;
            externalAppId = externalAppId2;
            appSettingsService = appSettingsService2;
            $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                AppPlacementInput appPlacementInput = (AppPlacementInput)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl5 = false;
                collection3.add(ModelConverterKt.toDomain((AppPlacementInput)it, (AppId)((AppId)input.getId()), (TenantId)origin.getTenantId()));
            }
            collection3 = (List)destination$iv$iv;
            appSettingsService2 = appSettingsService;
            externalAppId2 = externalAppId;
            profileId2 = profileId;
            bl3 = bl;
            collection5 = collection4;
            hexColor2 = hexColor;
            documentId2 = documentId;
            bl4 = bl2;
            string3 = string;
            string4 = string2;
            openUrlIn2 = openUrlIn;
            collection2 = collection3;
        } else {
            collection2 = null;
        }
        List list2 = input.getPlacementRemoves();
        if (list2 != null) {
            Collection<AppPlacement> collection6;
            $this$map$iv = list2;
            collection3 = collection2;
            openUrlIn = openUrlIn2;
            string2 = string4;
            string = string3;
            bl2 = bl4;
            documentId = documentId2;
            hexColor = hexColor2;
            collection4 = collection5;
            bl = bl3;
            profileId = profileId2;
            externalAppId = externalAppId2;
            appSettingsService = appSettingsService2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (AppPlacementInput)item$iv$iv;
                collection6 = destination$iv$iv;
                boolean bl6 = false;
                collection6.add(ModelConverterKt.toDomain((AppPlacementInput)it, (AppId)((AppId)input.getId()), (TenantId)origin.getTenantId()));
            }
            collection6 = (List)destination$iv$iv;
            appSettingsService2 = appSettingsService;
            externalAppId2 = externalAppId;
            profileId2 = profileId;
            bl3 = bl;
            collection5 = collection4;
            hexColor2 = hexColor;
            documentId2 = documentId;
            bl4 = bl2;
            string3 = string;
            string4 = string2;
            openUrlIn2 = openUrlIn;
            collection2 = collection3;
            collection = collection6;
        } else {
            collection = null;
        }
        ExternalAppSettings updatedApp = appSettingsService2.updateExternalApp(externalAppId2, profileId2, bl3, collection5, hexColor2, documentId2, bl4, string3, string4, openUrlIn2, collection2, collection);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return updatedApp;
    }

    @Transactional
    public void deleteExternalApp(@NotNull ExternalAppId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ExternalAppSettings origin = this.appSettingsService.getExternalApp(id);
        authContext.checkTenantManager(origin.getTenantId());
        this.appSettingsService.deleteExternalApp(origin, authContext.getProfileId());
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateAppPositions(@NotNull List<? extends AppId> appIds, @NotNull AuthorizationContext authContext) {
        boolean bl;
        TenantId tenantId;
        block12: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Object element$iv2;
            boolean bl2;
            block11: {
                Iterator $this$filterIsInstanceTo$iv$iv2;
                Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
                Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
                authContext.checkTenantManager();
                tenantId = authContext.getNonNullTenantId();
                Iterable $this$filterIsInstance$iv = appIds;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator = $this$filterIsInstanceTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    if (!(element$iv$iv instanceof CoreAppId)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List coreAppIds = (List)destination$iv$iv;
                Iterable $this$all$iv = coreAppIds;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        CoreAppId it = (CoreAppId)element$iv2;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it.getTenantId(), (Object)tenantId)) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                boolean $i$a$-require-AppSettingsApplicationService$updateAppPositions$32 = false;
                String $i$a$-require-AppSettingsApplicationService$updateAppPositions$32 = "All CoreApps must be part of the same Tenant.";
                throw new IllegalArgumentException($i$a$-require-AppSettingsApplicationService$updateAppPositions$32.toString());
            }
            Iterable $this$filterIsInstance$iv = appIds;
            boolean $i$f$filterIsInstance = false;
            element$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ExternalAppId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExternalAppId externalAppId = (ExternalAppId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(this.appSettingsService.getExternalApp((ExternalAppId)it));
            }
            List externalAppIds = (List)destination$iv$iv;
            Iterable $this$all$iv = externalAppIds;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv3 : $this$all$iv) {
                    ExternalAppSettings it = (ExternalAppSettings)element$iv3;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual((Object)it.getTenantId(), (Object)tenantId)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl6 = false;
            String string = "All ExternalApps must be part of the same Tenant.";
            throw new IllegalArgumentException(string.toString());
        }
        this.appSettingsService.saveAppPositions(appIds, tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteAppHomeScreenPositionsOfUsers(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        this.toroConnector.deleteAppHomeScreenPositionsOfUsers(tenantId);
    }

    public static final /* synthetic */ AppSettingsService access$getAppSettingsService$p(AppSettingsApplicationService $this) {
        return $this.appSettingsService;
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(AppSettingsApplicationService $this) {
        return $this.publisher;
    }
}

