/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.internal.appconfigmigration;

import de.justsoftware.admin.application.internal.appconfigmigration.AdaModelDto;
import de.justsoftware.admin.application.internal.appconfigmigration.MigrateAppConfigApplicationService;
import de.justsoftware.admin.application.internal.appconfigmigration.MigrateAppConfigToroDto;
import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.domain.appsettings.AppSettingsPermissionService;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppHomeScreenPosition;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppPlacement;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.domain.user.UserService;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.id.AppId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.mybatis.mapper.AppHomeScreenPositionMapper;
import de.justsoftware.admin.mybatis.mapper.AppPlacementMapper;
import de.justsoftware.admin.mybatis.mapper.CoreAppSettingsMapper;
import de.justsoftware.admin.mybatis.mapper.ExternalAppSettingsMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000 12\u00020\u0001:\u00011BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0012J4\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\"2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0 0\"H\u0012J\u0016\u0010%\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020$0 H\u0017J\"\u0010&\u001a\u00020\u00182\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0 0\"H\u0012J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001eH\u0012J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001eH\u0012J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u001bH\u0012J\"\u0010,\u001a\u00020\u00182\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\"H\u0012J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001eH\u0012J\u0010\u00100\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001eH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lde/justsoftware/admin/application/internal/appconfigmigration/MigrateAppConfigApplicationService;", "", "appHomeScreenPositionRepo", "Lde/justsoftware/admin/mybatis/mapper/AppHomeScreenPositionMapper;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "appSettingsPermissionService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;", "appPlacementRepo", "Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;", "coreAppRepo", "Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "externalAppSettingsRepo", "Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "userService", "Lde/justsoftware/admin/domain/user/UserService;", "(Lde/justsoftware/admin/mybatis/mapper/AppHomeScreenPositionMapper;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;Lde/justsoftware/admin/connector/drive/DriveApiConnector;Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/application/util/TransactionSupport;Lde/justsoftware/admin/domain/user/UserService;)V", "deleteAllApps", "", "tenantIds", "", "Lde/justsoftware/admin/id/TenantId;", "filterPlacements", "", "Lde/justsoftware/admin/application/internal/appconfigmigration/AdaModelDto;", "apps", "", "mapToAdaModel", "", "appsByTenant", "Lde/justsoftware/admin/application/internal/appconfigmigration/MigrateAppConfigToroDto;", "migrate", "persistApps", "persistCoreApp", "appDto", "persistExternalApp", "publishAppPositions", "tenantId", "publishApps", "persistedTenants", "publishCoreApp", "app", "publishExternalApp", "Companion", "admin-service"})
@SourceDebugExtension(value={"SMAP\nMigrateAppConfigApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateAppConfigApplicationService.kt\nde/justsoftware/admin/application/internal/appconfigmigration/MigrateAppConfigApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,214:1\n1208#2,2:215\n1238#2,2:217\n766#2:219\n857#2,2:220\n1241#2:222\n1360#2:223\n1446#2,5:224\n1179#2,2:229\n1253#2,2:231\n1549#2:233\n1620#2,3:234\n1256#2:237\n1549#2:245\n1620#2,2:246\n766#2:248\n857#2,2:249\n766#2:251\n857#2,2:252\n1622#2:254\n1855#2,2:255\n1855#2:257\n1855#2,2:258\n1856#2:260\n1855#2,2:261\n1549#2:263\n1620#2,3:264\n1855#2,2:267\n1855#2,2:270\n1549#2:273\n1620#2,3:274\n494#3,7:238\n215#4:269\n216#4:272\n*S KotlinDebug\n*F\n+ 1 MigrateAppConfigApplicationService.kt\nde/justsoftware/admin/application/internal/appconfigmigration/MigrateAppConfigApplicationService\n*L\n47#1:215,2\n47#1:217,2\n49#1:219\n49#1:220,2\n47#1:222\n57#1:223\n57#1:224,5\n83#1:229,2\n83#1:231,2\n91#1:233\n91#1:234,3\n83#1:237\n103#1:245\n103#1:246,2\n105#1:248\n105#1:249,2\n110#1:251\n110#1:252,2\n103#1:254\n120#1:255,2\n129#1:257\n130#1:258,2\n129#1:260\n148#1:261,2\n150#1:263\n150#1:264,3\n171#1:267,2\n178#1:270,2\n193#1:273\n193#1:274,3\n95#1:238,7\n177#1:269\n177#1:272\n*E\n"})
public class MigrateAppConfigApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppHomeScreenPositionMapper appHomeScreenPositionRepo;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final AppSettingsPermissionService appSettingsPermissionService;
    @NotNull
    private final AppPlacementMapper appPlacementRepo;
    @NotNull
    private final CoreAppSettingsMapper coreAppRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final ExternalAppSettingsMapper externalAppSettingsRepo;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final UserService userService;
    @NotNull
    private static final Logger log;

    public MigrateAppConfigApplicationService(@NotNull AppHomeScreenPositionMapper appHomeScreenPositionRepo, @NotNull AppSettingsService appSettingsService, @NotNull AppSettingsPermissionService appSettingsPermissionService, @NotNull AppPlacementMapper appPlacementRepo, @NotNull CoreAppSettingsMapper coreAppRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull ExternalAppSettingsMapper externalAppSettingsRepo, @NotNull Publisher publisher, @NotNull TransactionSupport transactionSupport, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)appHomeScreenPositionRepo, (String)"appHomeScreenPositionRepo");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)appSettingsPermissionService, (String)"appSettingsPermissionService");
        Intrinsics.checkNotNullParameter((Object)appPlacementRepo, (String)"appPlacementRepo");
        Intrinsics.checkNotNullParameter((Object)coreAppRepo, (String)"coreAppRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)externalAppSettingsRepo, (String)"externalAppSettingsRepo");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.appHomeScreenPositionRepo = appHomeScreenPositionRepo;
        this.appSettingsService = appSettingsService;
        this.appSettingsPermissionService = appSettingsPermissionService;
        this.appPlacementRepo = appPlacementRepo;
        this.coreAppRepo = coreAppRepo;
        this.driveApiConnector = driveApiConnector;
        this.externalAppSettingsRepo = externalAppSettingsRepo;
        this.publisher = publisher;
        this.transactionSupport = transactionSupport;
        this.userService = userService;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void migrate(@NotNull Collection<MigrateAppConfigToroDto> apps) {
        void $this$flatMapTo$iv$iv;
        MigrateAppConfigToroDto it;
        Iterable $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(apps, (String)"apps");
        log.info("Start AppConfig-Migration");
        log.info("Group apps by Tenant");
        Iterable $this$associateBy$iv = apps;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $this$filterTo$iv$iv;
            MigrateAppConfigToroDto migrateAppConfigToroDto = (MigrateAppConfigToroDto)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            it = (MigrateAppConfigToroDto)element$iv$iv;
            TenantId tenantId = it.getTenantId();
            boolean bl2 = false;
            Iterable $this$filter$iv = apps;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                MigrateAppConfigToroDto app = (MigrateAppConfigToroDto)element$iv$iv2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)app.getTenantId(), (Object)it.getTenantId())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            map.put(tenantId, list);
        }
        Map it2 = destination$iv$iv;
        boolean bl = false;
        log.info("Map placements");
        Map appsByTenant = this.mapToAdaModel(it2);
        log.info("Cache IconIds to be able to delete them in DRIVE after transaction is complete (and old apps are deleted)");
        Iterable $this$flatMap$iv = appsByTenant.keySet();
        boolean $i$f$flatMap = false;
        $this$associateByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (TenantId)element$iv$iv;
            boolean bl4 = false;
            Iterable list$iv$iv = SetsKt.plus((Set)this.coreAppRepo.getIconIds((TenantId)it), (Iterable)this.externalAppSettingsRepo.getIconIds((TenantId)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List iconIds = (List)destination$iv$iv;
        log.info("Clear previous data to avoid conflicts with incoming apps");
        this.deleteAllApps(appsByTenant.keySet());
        log.info("Persist apps");
        this.persistApps(appsByTenant);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    private Map<TenantId, List<AdaModelDto>> mapToAdaModel(Map<TenantId, ? extends Collection<MigrateAppConfigToroDto>> appsByTenant) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = appsByTenant.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map map = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Pair pair;
            Map map2 = map;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            TenantId tenantId = (TenantId)entry.getKey();
            Collection apps = (Collection)entry.getValue();
            UserGroup allTenantUsersGroup = this.userService.findAllTenantUsersGroup(tenantId);
            if (allTenantUsersGroup == null) {
                log.warn("allTenantUsersGroup not found. We assume the Tenant '" + tenantId + "' does not exist anymore so we skip migration of all apps for this tenant.");
                pair = TuplesKt.to((Object)tenantId, (Object)CollectionsKt.emptyList());
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = apps;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MigrateAppConfigToroDto migrateAppConfigToroDto = (MigrateAppConfigToroDto)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.toAdaModelDto(allTenantUsersGroup.getId()));
                }
                List adaApps = (List)destination$iv$iv2;
                List cleanedApps = this.filterPlacements((Collection)adaApps);
                pair = TuplesKt.to((Object)tenantId, (Object)cleanedApps);
            }
            entry = pair;
            map2.put(entry.getFirst(), entry.getSecond());
        }
        Map $this$filterValues$iv = map;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List apps = (List)entry.getValue();
            boolean bl = false;
            boolean bl2 = !((Collection)apps).isEmpty();
            if (!bl2) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<AdaModelDto> filterPlacements(Collection<AdaModelDto> apps) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = apps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AppPlacement it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void app;
            AdaModelDto adaModelDto = (AdaModelDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = app.getPlacements();
            boolean $i$f$filter = false;
            void var13_13 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (AppPlacement)element$iv$iv;
                boolean bl2 = false;
                boolean isGroupPlacement = it.getUserId() instanceof UserGroupId;
                if (!isGroupPlacement) {
                    log.info("Skipped placement since its for a Profile: '" + it + "'.");
                }
                if (!isGroupPlacement) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (AppPlacement)element$iv$iv;
                boolean bl3 = false;
                UserId userId = it.getUserId();
                Intrinsics.checkNotNull((Object)userId, (String)"null cannot be cast to non-null type de.justsoftware.admin.id.UserGroupId");
                boolean existsUserGroup = this.userService.existsUserGroup((UserGroupId)userId);
                if (!existsUserGroup) {
                    log.info("Skipped placement since its UserGroup does not exists: '" + it + "'.");
                }
                if (!existsUserGroup) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List placements = (List)destination$iv$iv2;
            collection.add(AdaModelDto.copy$default((AdaModelDto)app, (boolean)false, null, null, (Collection)placements, (int)7, null));
        }
        return (List)destination$iv$iv;
    }

    private void deleteAllApps(Set<TenantId> tenantIds) {
        Iterable $this$forEach$iv = tenantIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TenantId it = (TenantId)element$iv;
            boolean bl = false;
            this.appHomeScreenPositionRepo.deleteAllByTenantId(it);
            this.appPlacementRepo.deleteByTenant(it);
            this.coreAppRepo.deleteByTenant(it);
            this.externalAppSettingsRepo.deleteByTenant(it);
        }
    }

    private void persistApps(Map<TenantId, ? extends Collection<AdaModelDto>> appsByTenant) {
        Iterable $this$forEach$iv = appsByTenant.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection tenantApps = (Collection)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = tenantApps;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AdaModelDto it = (AdaModelDto)element$iv2;
                boolean bl2 = false;
                if (it.isCoreApp()) {
                    this.persistCoreApp(it);
                    continue;
                }
                this.persistExternalApp(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void persistCoreApp(AdaModelDto appDto) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        CoreAppSettings coreAppSettings = appDto.getCoreApp();
        if (coreAppSettings == null) {
            throw new IllegalArgumentException("Not a CoreApp");
        }
        CoreAppSettings app = coreAppSettings;
        this.coreAppRepo.upsertCoreApp(app);
        AppHomeScreenPosition position = new AppHomeScreenPosition((AppId)app.getId(), app.getPosition(), app.getTenantId());
        this.appHomeScreenPositionRepo.upsert(position);
        Iterable $this$forEach$iv = appDto.getPlacements();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            AppPlacement it = (AppPlacement)element$iv2;
            boolean bl = false;
            this.appPlacementRepo.upsert(it);
        }
        Iterable $this$map$iv = appDto.getPlacements();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppPlacement appPlacement = (AppPlacement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AppPermission(it.getTenantId(), app.getApp(), it.getUserId(), Role.READER));
        }
        List permissionAdds = (List)destination$iv$iv;
        AppSettingsPermissionService.updatePermissions$default((AppSettingsPermissionService)this.appSettingsPermissionService, (Collection)permissionAdds, null, (int)2, null);
    }

    private void persistExternalApp(AdaModelDto appDto) {
        ExternalAppSettings externalAppSettings = appDto.getExternalApp();
        if (externalAppSettings == null) {
            throw new IllegalArgumentException("Not an ExternalApp");
        }
        ExternalAppSettings app = externalAppSettings;
        this.externalAppSettingsRepo.upsert(app);
        this.appHomeScreenPositionRepo.upsert(new AppHomeScreenPosition((AppId)app.getId(), app.getPosition(), app.getTenantId()));
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)appDto.getPlacements());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppPlacement it = (AppPlacement)element$iv;
            boolean bl = false;
            this.appPlacementRepo.upsert(it);
        }
    }

    private void publishApps(Map<TenantId, ? extends List<AdaModelDto>> persistedTenants) {
        Map<TenantId, ? extends List<AdaModelDto>> $this$forEach$iv = persistedTenants;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<TenantId, ? extends List<AdaModelDto>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TenantId, ? extends List<AdaModelDto>> element$iv;
            Map.Entry<TenantId, ? extends List<AdaModelDto>> entry = element$iv = iterator.next();
            boolean bl = false;
            TenantId tenantId = entry.getKey();
            List<AdaModelDto> tenantApps = entry.getValue();
            Iterable $this$forEach$iv2 = tenantApps;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AdaModelDto it = (AdaModelDto)element$iv2;
                boolean bl2 = false;
                if (it.isCoreApp()) {
                    this.publishCoreApp(it);
                    continue;
                }
                this.publishExternalApp(it);
            }
            this.publishAppPositions(tenantId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void publishCoreApp(AdaModelDto app) {
        Collection<AppPermission> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(app.getCoreApp() != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable iterable = app.getPlacements();
        Collection collection2 = app.getPlacements();
        CoreAppSettings coreAppSettings = app.getCoreApp();
        Publisher publisher = this.publisher;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppPlacement appPlacement = (AppPlacement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AppPermission(it.getTenantId(), app.getCoreApp().getApp(), it.getUserId(), Role.READER));
        }
        collection = (List)destination$iv$iv;
        Publisher.publishUpdatedCoreAppSettings$default((Publisher)publisher, (CoreAppSettings)coreAppSettings, (Collection)collection2, (Collection)collection, null, (int)8, null);
    }

    private void publishExternalApp(AdaModelDto app) {
        if (!(app.getExternalApp() != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.publisher.publishUpdatedExternalAppSettings(app.getExternalApp(), app.getPlacements());
    }

    private void publishAppPositions(TenantId tenantId) {
        List tenantApps = this.appSettingsService.getAppsByTenant(tenantId);
        this.publisher.publishUpdatedAppPositions((Collection)tenantApps);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$publishApps(MigrateAppConfigApplicationService $this, Map persistedTenants) {
        $this.publishApps(persistedTenants);
    }

    public static final /* synthetic */ DriveApiConnector access$getDriveApiConnector$p(MigrateAppConfigApplicationService $this) {
        return $this.driveApiConnector;
    }

    static {
        Logger logger = LoggerFactory.getLogger(MigrateAppConfigApplicationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

