/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.util.sql;

import de.justsoftware.util.sql.AbstractShadowTableSqlGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.postgresql.Driver;

@ParametersAreNonnullByDefault
public class PostgresShadowTableSqlGenerator
extends AbstractShadowTableSqlGenerator {
    private static final String SCHEMA = "public";
    private static final String SELECT_ALL_TABLES = "select table_name from information_schema.tables where table_schema = ? and table_type = 'BASE TABLE' order by 1";
    private static final String DESCRIBE_TABLE = "select a.attname, pg_catalog.format_type(a.atttypid, a.atttypmod) from pg_catalog.pg_attribute a join pg_catalog.pg_class c on c.oid = a.attrelid join pg_catalog.pg_namespace n on n.oid = c.relnamespace where a.attnum > 0 and not a.attisdropped and c.relname = ? and n.nspname = ? order by a.attnum";
    private static final String DESCRIBE_PRIMARY_KEY = "select column_name from information_schema.table_constraints tc join information_schema.key_column_usage kcu on kcu.table_schema = tc.table_schema and kcu.constraint_name = tc.constraint_name where tc.table_name = ? and tc.table_schema = ? and tc.constraint_type = 'PRIMARY KEY' order by ordinal_position";
    private final String _dbUser;
    private final String _dbPwd;
    private final String _jdbcUrl;

    public PostgresShadowTableSqlGenerator(String jdbcUrl, String dbUser, String dbPwd) {
        this._jdbcUrl = jdbcUrl;
        this._dbUser = dbUser;
        this._dbPwd = dbPwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterable<String> iterTables(Connection conn) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> tables = new ArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(SELECT_ALL_TABLES);
            stmt.setString(1, SCHEMA);
            rs = stmt.executeQuery();
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            arrayList = tables;
        }
        catch (Throwable throwable) {
            this.close(rs, stmt);
            throw throwable;
        }
        this.close(rs, stmt);
        return arrayList;
    }

    @Override
    protected Class<? extends java.sql.Driver> getJdbcDriver() {
        return Driver.class;
    }

    @Override
    protected String getJdbcUrl() {
        return this._jdbcUrl;
    }

    @Override
    protected String getUser() {
        return this._dbUser;
    }

    @Override
    protected String getPassword() {
        return this._dbPwd;
    }

    @Override
    protected String getDeleteActionIdType() {
        return "BIGINT";
    }

    @Override
    protected String normalizeTableName(String tableName) {
        return tableName.toLowerCase(LOCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<AbstractShadowTableSqlGenerator.Column> describeTable(String tableName, Connection conn) throws SQLException {
        ArrayList<AbstractShadowTableSqlGenerator.Column> arrayList;
        ArrayList<AbstractShadowTableSqlGenerator.Column> columns = new ArrayList<AbstractShadowTableSqlGenerator.Column>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(DESCRIBE_TABLE);
            stmt.setString(1, tableName);
            stmt.setString(2, SCHEMA);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                String dataType = rs.getString(2);
                columns.add(new AbstractShadowTableSqlGenerator.Column(columnName, dataType));
            }
            if (columns.isEmpty()) {
                throw new IllegalStateException("No columns found for table " + tableName);
            }
            arrayList = columns;
        }
        catch (Throwable throwable) {
            this.close(rs, stmt);
            throw throwable;
        }
        this.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> describePrimaryKey(String tableName, Connection conn) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> primaryKeys = new ArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(DESCRIBE_PRIMARY_KEY);
            stmt.setString(1, tableName);
            stmt.setString(2, SCHEMA);
            rs = stmt.executeQuery();
            while (rs.next()) {
                primaryKeys.add(rs.getString(1));
            }
            arrayList = primaryKeys;
        }
        catch (Throwable throwable) {
            this.close(rs, stmt);
            throw throwable;
        }
        this.close(rs, stmt);
        return arrayList;
    }
}

