/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.util.sql;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractShadowTableSqlGenerator {
    public static final Locale LOCALE = Locale.getDefault();
    private static final String DELETE_ACTION_ID_FK_COLUMN = "DELETE_ACTION_ID";
    private static final String DELETE_ACTION_ID_TABLE = "DELETE_ACTION";
    private static final String DELETE_ACTION_ID_PK_COLUMN = "ID";
    private static final String SHADOW_NAME_PREFIX = "SH_";
    private static final String SHADOW_TABLE_TABLE = "SHADOW_TABLE";
    private static final String SHADOW_TABLE_TABLE_NAME_COLUMN = "TABLE_NAME";
    private static final String SHADOW_TABLE_SHADOW_TABLE_NAME_COLUMN = "SHADOW_TABLE_NAME";
    private static final String SHADOW_TABLE_DELETE_ACTION_MANDATORY_COLUMN = "DELETE_ACTION_MANDATORY";
    private static final String FALSE = "f";
    private static final int TABLE_NAME_MAX_LENGTH = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateScriptForAllTables(PrintStream out) {
        Connection conn = null;
        try {
            conn = this.openConnection();
            for (String tableName : this.iterTables(conn)) {
                if (this.isShadowTable(tableName)) continue;
                this.generateScriptForTable(tableName, conn, out);
                out.println();
            }
            out.println();
            for (String tableName : this.iterTables(conn)) {
                if (this.isShadowTable(tableName)) continue;
                this.generateInsertForTable(tableName, out);
            }
            this.generateFooter(null, conn, out);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private boolean isShadowTable(String tableName) {
        return tableName.toLowerCase(LOCALE).startsWith("sh_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateScriptForTable(String tableName, PrintStream out) {
        Connection conn = null;
        try {
            conn = this.openConnection();
            String normalizedTableName = this.normalizeTableName(tableName);
            this.generateScriptForTable(normalizedTableName, conn, out);
            out.println();
            this.generateInsertForTable(normalizedTableName, out);
            this.generateFooter(normalizedTableName, conn, out);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private void generateScriptForTable(String tableName, Connection conn, PrintStream out) throws SQLException {
        List<Column> columns = this.describeTable(tableName, conn);
        List<String> primaryKeyColumns = this.describePrimaryKey(tableName, conn);
        out.print("CREATE TABLE ");
        out.print(this.generateShadowTableName(tableName));
        out.println(" (");
        for (Column column : columns) {
            out.print("    \"");
            out.print(column.getName());
            out.print("\" ");
            out.print(column.getType());
            out.println(",");
        }
        out.print("    ");
        out.print(DELETE_ACTION_ID_FK_COLUMN);
        out.print(" ");
        out.print(this.getDeleteActionIdType());
        out.println(",");
        out.print("    FOREIGN KEY (");
        out.print(DELETE_ACTION_ID_FK_COLUMN);
        out.print(") REFERENCES ");
        out.print(DELETE_ACTION_ID_TABLE);
        out.print(" (");
        out.print(DELETE_ACTION_ID_PK_COLUMN);
        out.print(")");
        if (!primaryKeyColumns.isEmpty()) {
            out.println(",");
            out.print("    PRIMARY KEY(");
            boolean first = true;
            for (String primaryKeyColumn : primaryKeyColumns) {
                if (!first) {
                    out.print(", ");
                }
                out.print("\"");
                out.print(primaryKeyColumn);
                out.print("\"");
                first = false;
            }
            out.print(")");
        }
        out.println();
        out.println(");");
    }

    private void generateInsertForTable(String tableName, PrintStream out) {
        out.print("INSERT INTO ");
        out.print(this.normalizeTableName(SHADOW_TABLE_TABLE));
        out.print(" (");
        out.print(SHADOW_TABLE_TABLE_NAME_COLUMN);
        out.print(",");
        out.print(SHADOW_TABLE_SHADOW_TABLE_NAME_COLUMN);
        out.print(",");
        out.print(SHADOW_TABLE_DELETE_ACTION_MANDATORY_COLUMN);
        out.print(") VALUES ('");
        out.print(tableName);
        out.print("','");
        out.print(this.generateShadowTableName(tableName));
        out.print("','");
        out.print(FALSE);
        out.println("');");
    }

    private void generateFooter(@Nullable String tableName, Connection conn, PrintStream out) throws SQLException {
        out.println();
        out.println("/*");
        out.print(" * TODO Please check the ");
        out.print(SHADOW_TABLE_DELETE_ACTION_MANDATORY_COLUMN);
        out.println(" value for each table for correctness.");
        ArrayList<String> problematicColumnNames = new ArrayList<String>();
        if (tableName != null && !this.checkLength(tableName)) {
            problematicColumnNames.add(tableName);
        }
        if (tableName == null) {
            for (String tblName : this.iterTables(conn)) {
                if (this.checkLength(tblName)) continue;
                problematicColumnNames.add(tblName);
            }
        }
        if (!problematicColumnNames.isEmpty()) {
            out.println(" *");
            out.println(" * The following table names had to be truncated because they were too long: ");
            out.println(" *");
            for (String tblName : problematicColumnNames) {
                out.print(" * ");
                out.print(tblName);
                out.print(" ==> ");
                out.println(this.generateShadowTableName(tblName));
            }
        }
        out.println("*/");
    }

    @Nonnull
    private Connection openConnection() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        String jdbcUrl = this.getJdbcUrl();
        Properties info = new Properties();
        info.put("user", this.getUser());
        String password = this.getPassword();
        if (password != null) {
            info.put("password", password);
        }
        return this.getJdbcDriver().newInstance().connect(jdbcUrl, info);
    }

    @Nonnull
    protected String generateShadowTableName(String tableName) {
        Object shadowTableName = SHADOW_NAME_PREFIX + tableName;
        if (((String)shadowTableName).length() > 30) {
            shadowTableName = ((String)shadowTableName).substring(0, 30);
        }
        return this.normalizeTableName((String)shadowTableName);
    }

    protected boolean checkLength(String tableName) {
        return tableName.length() + SHADOW_NAME_PREFIX.length() <= 30;
    }

    protected void close(@Nullable ResultSet rs, @Nullable Statement stmt) throws SQLException {
        SQLException onClose = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException s) {
                onClose = s;
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException s) {
                onClose = s;
            }
        }
        if (onClose != null) {
            throw onClose;
        }
    }

    @Nonnull
    protected abstract Iterable<String> iterTables(Connection var1) throws SQLException;

    @Nonnull
    protected abstract Class<? extends Driver> getJdbcDriver();

    @Nonnull
    protected abstract String getJdbcUrl();

    @Nonnull
    protected abstract String getUser();

    @CheckForNull
    protected abstract String getPassword();

    @Nonnull
    protected abstract String getDeleteActionIdType();

    @Nonnull
    protected abstract String normalizeTableName(String var1);

    @Nonnull
    protected abstract List<Column> describeTable(String var1, Connection var2) throws SQLException;

    @Nonnull
    protected abstract List<String> describePrimaryKey(String var1, Connection var2) throws SQLException;

    public static final class Column {
        private final String _name;
        private final String _type;

        public Column(@Nonnull String name, @Nonnull String type) {
            this._name = name;
            this._type = type;
        }

        @Nonnull
        public String getName() {
            return this._name;
        }

        @Nonnull
        public String getType() {
            return this._type;
        }
    }
}

