BEGIN;

-- first delete all possibly existing CONTENT_BUTTONS
DELETE FROM entity_component
WHERE component_type = 'CONTENT_BUTTONS'
AND EXISTS (SELECT 1 FROM customer_category WHERE customertype = 'standard');

-- add the CONTENT_BUTTONS component if there is another component in position 5 (BOTTOM_RIGHT) and use the lowest index
INSERT INTO entity_component (entity_id, component_type, position, "order", visible, open)
SELECT e.id, 'CONTENT_BUTTONS', 5, least(min(c1."order")-1, 0), 't', 't'
FROM entity e JOIN entity_component c1 ON e.id = c1.entity_id
WHERE c1.position = 5
AND EXISTS (SELECT 1 FROM customer_category WHERE customertype = 'standard')
GROUP BY e.id;

COMMIT;
