BEGIN;

ALTER TABLE task_filter_order DROP CONSTRAINT task_filter_order_pos_uq;

DELETE FROM task_filter_order t1
WHERE EXISTS (
    SELECT 1
    FROM task_filter_order t2
    WHERE t1.filter_id = t2.filter_id
    AND t1.position = t2.position
    AND t1.task_id > t2.task_id
);

-- need to be deferrable because intermediate results while moving tasks up or down may violate the constraint
ALTER TABLE task_filter_order
ADD CONSTRAINT task_filter_order_pos_uk
UNIQUE (filter_id, position)
DEFERRABLE INITIALLY IMMEDIATE;

COMMIT;
