BEGIN;

ALTER TABLE conversation ADD COLUMN last_message_date timestamp without time zone;

UPDATE conversation c
SET last_message_date = (
    SELECT max(create_date)
    FROM conversation_message
    WHERE conversation_id = c.id
);

UPDATE conversation
SET last_message_date = create_date
WHERE last_message_date IS NULL;

ALTER TABLE conversation ALTER last_message_date set not null, ALTER last_message_date set default now();

CREATE INDEX conversation_last_message_date_idx ON conversation (last_message_date DESC);

COMMIT;
