BEGIN;

INSERT INTO entity_nav_link
    (id, entity_id, text, target, list_index)
    (SELECT nextval('entity_nav_link_seq'), null, text, target, list_index from entity_nav_link 
        where entity_id = 0 and not exists 
            (select default_value::integer from base_property 
                where property_name='Settings/Registration/Default Entity Id' and container_name='systemSettings')
    );

INSERT INTO entity_nav_sublink
    (id, parent_id, text, target, list_index)
    (SELECT nextval('entity_nav_sublink_seq'), ld.id AS parent_id, s.text, s.target, s.list_index
        FROM entity_nav_link l
        INNER JOIN entity_nav_sublink s
        ON (l.id = s.parent_id)
        INNER JOIN entity_nav_link ld
        ON (ld.entity_id is null and ld.list_index = l.list_index)
        WHERE l.entity_id = coalesce((select default_value::integer from base_property 
            where property_name='Settings/Registration/Default Entity Id' and container_name='systemSettings'), 0));

COMMIT;
