BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00008, '7.8', '00008_#patch_copy_like_subscribe_from_attachment_to_workstream', 'FEATURE', '#8386 Workstream: Likes/Abos zu Anhängen nicht mehr mit Microblog-Beitrag synchronisieren', now());

INSERT INTO like_table(liker_id, item_id, item_type)
SELECT l.liker_id, a.entry_id, 'WORKSTREAM_MESSAGE'
FROM like_table l, workstream_attachment a
WHERE l.item_id = a.item_id AND l.item_type = a.item_type
AND (l.liker_id, a.entry_id, 'WORKSTREAM_MESSAGE') NOT IN (
    SELECT liker_id, item_id, item_type FROM like_table
);

INSERT INTO like_subscribe(subscriber_id, item_id, item_type)
SELECT s.subscriber_id, a.entry_id, 'WORKSTREAM_MESSAGE'
FROM like_subscribe s, workstream_attachment a
WHERE s.item_id = a.item_id AND s.item_type = a.item_type
AND (s.subscriber_id, a.entry_id, 'WORKSTREAM_MESSAGE') NOT IN (
    SELECT subscriber_id, item_id, item_type FROM like_subscribe
);

COMMIT;
