BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00002, '7.4', '00002_#patch_drop_wall_id.sql', 'BUGFIX', '#6903 einige server haben spalte wall_id in workstream_entry', now());

CREATE OR REPLACE FUNCTION DROPCOLUMN(tblSchema VARCHAR, tblName VARCHAR, colName VARCHAR) RETURNS void AS $$
DECLARE
     execString TEXT;
BEGIN
     execString := 'ALTER TABLE ';
     IF tblSchema != NULL THEN
         execString := execString || quote_ident(tblSchema) || '.';
     END IF;
     execString := execString || quote_ident(tblName) || ' DROP COLUMN ' || quote_ident(colName);
     EXECUTE execString;
EXCEPTION
     WHEN OTHERS THEN
         NULL;
END;
$$ LANGUAGE plpgsql;

SELECT DROPCOLUMN(null, 'workstream_entry', 'wall_id');

DROP FUNCTION DROPCOLUMN(tblSchema VARCHAR, tblName VARCHAR, colName VARCHAR);

COMMIT;
