BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00007, '7.2', '00007_#patch_create_shadow_tables.sql', 'FEATURE', 'refs #4853 Basis für "als gelöscht markieren"', now());

CREATE TABLE sh_accepted_external_invitatio (
    "inviter_id" numeric(10,0),
    "person_id" numeric(10,0),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "inviter_id")
);

CREATE TABLE sh_contact_data_basic (
    "person_id" bigint,
    "type" smallint,
    "co" character varying(130),
    "street" character varying(255),
    "zipcode" character varying(10),
    "zipcode_successive" character(1),
    "city" character varying(255),
    "country_id" bigint,
    "email" character varying(100),
    "phone" character varying(100),
    "fax" character varying(100),
    "mobile" character varying(100),
    "website" character varying(255),
    "created_at" timestamp without time zone,
    "modified_at" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("type", "person_id")
);

CREATE TABLE sh_default_album (
    "item_id" bigint,
    "item_type" character varying(32),
    "album_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_dynamic_person_attribute (
    "person_id" bigint,
    "orderidx" integer,
    "tab" character varying(255),
    "section" character varying(255),
    "name" character varying(255),
    "value" text,
    "section_clone" integer,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_email_notification_setting (
    "person_id" bigint,
    "subscribe_root_items" character(1),
    "subscribe_other_items" character(1),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    "notifications_enabled" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id")
);

CREATE TABLE sh_email_user (
    "user_id" character varying(128),
    "domain" character varying(128),
    "password" character varying(64),
    "person_id" bigint,
    "password_encrypted" character varying(64),
    "created_at" timestamp without time zone,
    "modified_at" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_employment (
    "id" numeric(10,0),
    "employer" character varying,
    "position" character varying(50),
    "city" character varying(50),
    "start_at" date,
    "end_at" date,
    "person_id" numeric(10,0),
    "website" character varying(256),
    "industry_id" smallint,
    "occupation_id" smallint,
    "job_status_id" smallint,
    "activities" character varying(1024),
    "current" character(1),
    "created_at" timestamp without time zone,
    "modified_at" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id", "person_id")
);

CREATE TABLE sh_entity (
    "id" bigint,
    "name" character varying(255),
    "start_at" timestamp without time zone,
    "end_at" timestamp without time zone,
    "closing_date" timestamp without time zone,
    "timezone" character varying(255),
    "participant_limited" character(1),
    "participant_count" integer,
    "description" text,
    "location" character varying(255),
    "tags" text,
    "subdomain" character varying(255),
    "subdomain_deactivated" character(1),
    "external_domain" character varying(255),
    "google_maps_api_key" character varying(255),
    "logo" character varying(255),
    "icon" character varying(255),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    "widgets_show_sub_entities" character(1),
    "network_id" bigint,
    "group_id" bigint,
    "wiki_id" bigint,
    "appointment_id" bigint,
    "aggregate_workstream" character(1),
    "category" character varying(32),
    "text_if_not_visible" text,
    "public_visible" character(1),
    "stream_workstream_to_parents" character(1),
    "use_parent_admin_as_coadmin" character(1),
    "entity_type" character varying(255),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_entity_component (
    "entity_id" bigint,
    "component_type" character varying(255),
    "position" bigint,
    "order" integer,
    "visible" character(1),
    "open" character(1),
    "customized_title" character varying,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id", "component_type")
);

CREATE TABLE sh_entity_component_open_for (
    "entity_id" bigint,
    "component_type" character varying(255),
    "authority_name" character varying(50),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id", "component_type", "authority_name")
);

CREATE TABLE sh_entity_contact_data (
    "entity_id" bigint,
    "office" character varying(255),
    "contact_name" character varying(255),
    "website" character varying(255),
    "email" character varying(255),
    "phone" character varying(100),
    "fax" character varying(100),
    "street" character varying(255),
    "zipcode" character varying(50),
    "city" character varying(255),
    "state" character varying(255),
    "country_id" bigint,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    "lat" double precision,
    "lng" double precision,
    "not_resolvable" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id")
);

CREATE TABLE sh_entity_design (
    "entity_id" bigint,
    "page_border_color" character(7),
    "nav_bg_color" character(7),
    "nav_quicklink_color" character(7),
    "header_bg_color" character(7),
    "header_border_color" character(7),
    "header_text_color" character(7),
    "header_link_color" character(7),
    "heading_box_bg_color" character(7),
    "heading_box_text_color" character(7),
    "heading_box_border_color" character(7),
    "subheading_box_bg_color" character(7),
    "subheading_box_text_color" character(7),
    "subheading_box_link_color" character(7),
    "subheading_box_border_color" character(7),
    "subheading_box_line_color" character(7),
    "inner_bg_color" character(7),
    "outer_bg_color" character(7),
    "text_color" character(7),
    "link_color" character(7),
    "line_color" character(7),
    "button_bg_color" character(7),
    "button_text_color" character(7),
    "box_top_border" character(1),
    "box_bottom_border" character(1),
    "box_left_border" character(1),
    "box_right_border" character(1),
    "horizontal_nav_bg_color" character(7),
    "horizontal_nav_link_color" character(7),
    "horizontal_nav" character varying(255),
    "heading_box" character varying(255),
    "banner" character varying(255),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    "bg_horizontal_repeat" character(1),
    "bg_vertical_repeat" character(1),
    "bg_image" character varying(255),
    "bg_scroll_fix" character(1),
    "horizontal_nav_selected_link" character(7),
    "horizontal_nav_selected_bg" character(7),
    "horizontal_nav_sub_line" character(7),
    "horizontal_nav_selected_image" character varying(255),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id")
);

CREATE TABLE sh_entity_dynamic_attribute (
    "entity_id" bigint,
    "attribute_id" character varying(255),
    "attribute_value" text,
    "position" integer,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_entity_link (
    "entity_id" bigint,
    "linked_entity_id" bigint,
    "order" integer,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id", "linked_entity_id")
);

CREATE TABLE sh_entity_member (
    "person_id" bigint,
    "entity_id" bigint,
    "member_status" integer,
    "member_role" integer,
    "status_modify_date" timestamp without time zone,
    "last_notify_status" integer,
    "last_notify_date" timestamp without time zone,
    "inviter_id" bigint,
    "invite_message" text,
    "modify_date" timestamp without time zone,
    "create_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "entity_id")
);

CREATE TABLE sh_entity_nav_link (
    "id" bigint,
    "entity_id" bigint,
    "text" character varying(63),
    "target" character varying(255),
    "list_index" integer,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_entity_nav_sublink (
    "id" bigint,
    "parent_id" bigint,
    "text" character varying(63),
    "target" character varying(255),
    "list_index" integer,
    "create_date" timestamp without time zone,
    "edit_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_entity_option (
    "entity_id" bigint,
    "option_name" character varying(100),
    "option_value" character varying(100),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id", "option_name")
);

CREATE TABLE sh_entity_privacy (
    "entity_id" bigint,
    "privacy_type" character varying(50),
    "authority_name" character varying(50),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_entity_to_entity_type_priva (
    "entity_id" bigint,
    "entity_type" character varying(255),
    "authority_name" character varying(50),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id", "entity_type", "authority_name")
);

CREATE TABLE sh_entity_version (
    "id" bigint,
    "entity_id" bigint,
    "parent_version_id" bigint,
    "person_id" bigint,
    "major_version" integer,
    "minor_version" integer,
    "version_type" character varying(255),
    "version_status" character varying(255),
    "release_date" timestamp without time zone,
    "expiration_date" timestamp without time zone,
    "draft_version" bigint,
    "change_message" character varying(255),
    "comment_for_reviewers" character varying(255),
    "target_type" character varying(255),
    "read_date" timestamp without time zone,
    "decline_message" character varying(255),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_entity_version_components (
    "entity_version_id" bigint,
    "multi_wiki_version_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_entity_version_review (
    "entity_version_id" bigint,
    "reviewer_id" bigint,
    "inviter_id" bigint,
    "review_status" character varying(255),
    "review_order" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_version_id", "reviewer_id")
);

CREATE TABLE sh_external_invitation (
    "inviter_id" numeric(10,0),
    "email" character varying(100),
    "hash" character varying(100),
    "entity_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("hash")
);

CREATE TABLE sh_ignore_list (
    "person_id" numeric(10,0),
    "ignored_id" numeric(10,0),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "ignored_id")
);

CREATE TABLE sh_item_unread (
    "person_id" bigint,
    "item_id" bigint,
    "item_type" character varying,
    "creation_date" timestamp without time zone,
    "item_modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "item_id", "item_type")
);

CREATE TABLE sh_like_subscribe (
    "subscriber_id" bigint,
    "item_id" bigint,
    "item_type" character varying,
    "created_at" timestamp without time zone,
    "modified_at" timestamp without time zone,
    "passive" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("item_id", "item_type", "subscriber_id")
);

CREATE TABLE sh_like_table (
    "liker_id" bigint,
    "item_id" bigint,
    "item_type" character varying,
    "created_at" timestamp without time zone,
    "modified_at" timestamp without time zone,
    "recent" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("item_id", "item_type", "liker_id")
);

CREATE TABLE sh_like_unsubscribe (
    "unsubscriber_id" bigint,
    "item_id" bigint,
    "item_type" character varying,
    "created_at" timestamp without time zone,
    "modified_at" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("item_id", "item_type", "unsubscriber_id")
);

CREATE TABLE sh_map_person_person (
    "person_id" numeric(10,0),
    "friend_id" numeric(10,0),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "friend_id")
);

CREATE TABLE sh_map_person_person_invite (
    "person_id" numeric(10,0),
    "friend_id" numeric(10,0),
    "message" text,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "friend_id")
);

CREATE TABLE sh_map_person_relationship_typ (
    "person_id" numeric(10,0),
    "relationshiptype_id" numeric(2,0),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "relationshiptype_id")
);

CREATE TABLE sh_mdl_album (
    "id" bigint,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "module" character(1),
    "owner_id" bigint,
    "create_date" timestamp without time zone,
    "edit_date" timestamp without time zone,
    "title" character varying(255),
    "description" text,
    "location" character varying(80),
    "friends_only" character(1),
    "old_album_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_mdl_album_image (
    "id" bigint,
    "title" character varying(255),
    "album_id" bigint,
    "filename" character varying(255),
    "owner_id" bigint,
    "create_date" timestamp without time zone,
    "edit_date" timestamp without time zone,
    "old_album_image_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_mdl_comment (
    "id" bigint,
    "author_id" bigint,
    "text" character varying(1000),
    "posted_at" timestamp without time zone,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "custom_info" character varying(255),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_mdl_document (
    "id" bigint,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "description" character varying(1024),
    "keywords" character varying(4096),
    "download_count" bigint,
    "checked_out_by" bigint,
    "checked_out_at" timestamp without time zone,
    "status" integer,
    "status_changed_by" bigint,
    "status_changed_at" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_mdl_document_version (
    "id" bigint,
    "version" integer,
    "filename" character varying(256),
    "document_id" bigint,
    "url" character varying(1024),
    "uploaded_by" bigint,
    "uploaded_at" timestamp without time zone,
    "size" bigint,
    "file_type_id" bigint,
    "restored_from" integer,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_mdl_forum_migration (
    "entity_id" bigint,
    "old_forum_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_mdl_forum_topic (
    "id" bigint,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "caption" character varying(255),
    "edit_date" timestamp without time zone,
    "create_date" timestamp without time zone,
    "author_id" bigint,
    "hits" bigint,
    "old_topic_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_mdl_forum_topic_article (
    "id" bigint,
    "topic_id" bigint,
    "create_date" timestamp without time zone,
    "author_id" bigint,
    "article_text" text,
    "editor_id" bigint,
    "edit_date" timestamp without time zone,
    "edit_reason" character varying(50),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_mdl_video_link (
    "id" bigint,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "title" character varying(255),
    "url" character varying(255),
    "edit_date" timestamp without time zone,
    "create_date" timestamp without time zone,
    "author_id" bigint,
    "public" character(1),
    "video_file" character varying(256),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_message (
    "id" numeric(10,0),
    "sender_id" numeric(10,0),
    "message" text,
    "subject" character varying(255),
    "date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_message_inbox (
    "owner_id" numeric(10,0),
    "message_id" numeric(10,0),
    "message_status" numeric(1,0),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("owner_id", "message_id")
);

CREATE TABLE sh_message_outbox (
    "owner_id" numeric(10,0),
    "message_id" numeric(10,0),
    "message_status" numeric(1,0),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("owner_id", "message_id")
);

CREATE TABLE sh_message_recipient (
    "message_id" numeric(10,0),
    "recipient_id" numeric(10,0),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_multi_wiki (
    "id" bigint,
    "entity_id" bigint,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_multi_wiki_section_visibili (
    "version_section_id" bigint,
    "authority_name" character varying(50),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("version_section_id", "authority_name")
);

CREATE TABLE sh_multi_wiki_version (
    "id" bigint,
    "wiki_id" bigint,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_multi_wiki_version_section (
    "id" bigint,
    "version_id" bigint,
    "headline" character varying,
    "html" text,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    "section_id" bigint,
    "section_order" integer,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_news_blog (
    "id" bigint,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "headline" character varying(255),
    "create_date" timestamp without time zone,
    "edit_date" timestamp without time zone,
    "author_id" bigint,
    "source_text" character varying(255),
    "source_href" character varying(255),
    "keywords" character varying(255),
    "text" text,
    "image_id" bigint,
    "draft" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_person (
    "id" numeric(10,0),
    "last_login" timestamp without time zone,
    "show_tempstartpage" character(1),
    "account_active" character(1),
    "title" character varying(255),
    "firstname" character varying(50),
    "surname" character varying(100),
    "email" character varying(100),
    "newmail" character varying(100),
    "activation_hash" character varying(100),
    "birthday" date,
    "password_hash" character(28),
    "keywords" character varying(255),
    "gender" smallint,
    "zodiac_id" numeric(2,0),
    "relationshipstatus_id" numeric(2,0),
    "politview_id" numeric(2,0),
    "religview_id" numeric(2,0),
    "home_city" character varying(255),
    "home_country" character varying(255),
    "language_id" character(2),
    "current_city" character varying(255),
    "current_country" character varying(255),
    "password_question" character varying(255),
    "password_answer" character varying(255),
    "registerdate" timestamp without time zone,
    "terms_accepted" character(1),
    "image" character varying(64),
    "allow_newsletter" character(1),
    "blocked" character(1),
    "show_actions_in_networks" character(1),
    "default_timezone" character varying(100),
    "modified_at" timestamp without time zone,
    "created_at" timestamp without time zone,
    "birthday_visibility" character varying(64),
    "status_id" smallint,
    "hashed_id" character varying(32),
    "additional_title" character varying(255),
    "pseudonym" character varying(255),
    "pseudonym_enabled" character(1),
    "visible_for_restricted" character(1),
    "deleted" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_person_external_ids (
    "person_id" bigint,
    "external_person_id" character varying(4000),
    "external_system_id" character varying(50),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "external_system_id")
);

CREATE TABLE sh_person_nofriends_message (
    "person_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id")
);

CREATE TABLE sh_person_primary_network (
    "person_id" bigint,
    "network_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_person_to_role (
    "person_id" bigint,
    "role_name" character varying(15),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "role_name")
);

CREATE TABLE sh_profile_component (
    "person_id" bigint,
    "component_type" character varying(255),
    "position" bigint,
    "order" integer,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "component_type")
);

CREATE TABLE sh_profile_component_visibilit (
    "person_id" bigint,
    "component_type" character varying(255),
    "authority_name" character varying(50),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "component_type", "authority_name")
);

CREATE TABLE sh_profile_visibility_for_role (
    "person_id" bigint,
    "role_name_may_see" character varying,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_random_member_component_cfg (
    "entity_id" bigint,
    "role_name" character varying(15),
    "order" integer,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id", "role_name")
);

CREATE TABLE sh_raweditor_version (
    "id" bigint,
    "raweditor_id" bigint,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "editor_type" character varying(255),
    "version" integer,
    "text" text,
    "create_date" timestamp without time zone,
    "author_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_rights (
    "person_id" numeric(10,0),
    "admin" character(1),
    "translator" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id")
);

CREATE TABLE sh_school (
    "id" numeric(10,0),
    "name" character varying(50),
    "gradyear" numeric(4,0),
    "person_id" numeric(10,0),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_start_page_profile (
    "id" bigint,
    "person_id" bigint,
    "language" character varying(2),
    "activated" character(1),
    "image" character varying(255),
    "deleted" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_survey (
    "id" bigint,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "title" character varying(255),
    "expired_date" timestamp without time zone,
    "owner_id" bigint,
    "result_visibilty" integer,
    "anonym" character(1),
    "participant_may_modify" character(1),
    "auto_delete_answers" character(1),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_survey_participant_answer (
    "participant_id" bigint,
    "survey_question_id" bigint,
    "survey_predefined_answer_id" bigint,
    "freetext_answer" text,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_survey_predefined_answer (
    "id" bigint,
    "survey_question_id" bigint,
    "answer" text,
    "order" integer,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_survey_question (
    "id" bigint,
    "survey_id" bigint,
    "question" text,
    "order" integer,
    "freetext_answer" character(1),
    "min_answer" integer,
    "max_answer" integer,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_university (
    "id" numeric(10,0),
    "name" character varying(50),
    "degree" character varying(50),
    "course" character varying(50),
    "gradyear" numeric(4,0),
    "person_id" numeric(10,0),
    "university_department_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_user_setting (
    "id" bigint,
    "person_id" numeric(10,0),
    "key" character varying(30),
    "value" character varying,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_wiki_editor (
    "id" bigint,
    "parent_item_id" bigint,
    "parent_item_type" character varying(32),
    "old_group_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_wiki_editor_backup (
    "wiki_editor_id" bigint,
    "headline" character varying(255),
    "wiki_text" text,
    "author_id" bigint,
    "create_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("wiki_editor_id")
);

CREATE TABLE sh_wiki_editor_version (
    "id" bigint,
    "wiki_editor_id" bigint,
    "headline" character varying(255),
    "wiki_text" text,
    "version" integer,
    "author_id" bigint,
    "create_date" timestamp without time zone,
    "restored_from" bigint,
    "old_page_id" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_workstream (
    "entry_id" bigint,
    "item_id" bigint,
    "item_type" character varying(32),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_workstream_attachment (
    "entry_id" bigint,
    "item_id" bigint,
    "item_type" character varying(32),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("item_id", "item_type")
);

CREATE TABLE sh_workstream_entry (
    "id" bigint,
    "type" character varying(32),
    "origin_item_id" bigint,
    "origin_item_type" character varying(32),
    "author_id" bigint,
    "created_at" timestamp without time zone,
    "modified_at" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_workstream_entry_attribute (
    "entry_id" bigint,
    "key" character varying(24),
    "value" character varying(5000),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('accepted_external_invitation','sh_accepted_external_invitatio','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('contact_data_basic','sh_contact_data_basic','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('default_album','sh_default_album','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('dynamic_person_attribute','sh_dynamic_person_attribute','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('email_notification_setting','sh_email_notification_setting','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('email_user','sh_email_user','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('employment','sh_employment','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity','sh_entity','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_component','sh_entity_component','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_component_open_for','sh_entity_component_open_for','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_contact_data','sh_entity_contact_data','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_design','sh_entity_design','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_dynamic_attribute','sh_entity_dynamic_attribute','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_link','sh_entity_link','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_member','sh_entity_member','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_nav_link','sh_entity_nav_link','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_nav_sublink','sh_entity_nav_sublink','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_option','sh_entity_option','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_privacy','sh_entity_privacy','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_to_entity_type_privacy','sh_entity_to_entity_type_priva','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_version','sh_entity_version','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_version_components','sh_entity_version_components','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_version_review','sh_entity_version_review','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('external_invitation','sh_external_invitation','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ignore_list','sh_ignore_list','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('item_unread','sh_item_unread','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('like_subscribe','sh_like_subscribe','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('like_table','sh_like_table','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('like_unsubscribe','sh_like_unsubscribe','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('map_person_person','sh_map_person_person','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('map_person_person_invite','sh_map_person_person_invite','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('map_person_relationship_type','sh_map_person_relationship_typ','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_album','sh_mdl_album','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_album_image','sh_mdl_album_image','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_comment','sh_mdl_comment','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_document','sh_mdl_document','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_document_version','sh_mdl_document_version','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_forum_migration','sh_mdl_forum_migration','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_forum_topic','sh_mdl_forum_topic','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_forum_topic_article','sh_mdl_forum_topic_article','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('mdl_video_link','sh_mdl_video_link','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('message','sh_message','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('message_inbox','sh_message_inbox','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('message_outbox','sh_message_outbox','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('message_recipient','sh_message_recipient','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('multi_wiki','sh_multi_wiki','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('multi_wiki_section_visibility','sh_multi_wiki_section_visibili','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('multi_wiki_version','sh_multi_wiki_version','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('multi_wiki_version_section','sh_multi_wiki_version_section','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('news_blog','sh_news_blog','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('person','sh_person','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('person_external_ids','sh_person_external_ids','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('person_nofriends_message','sh_person_nofriends_message','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('person_primary_network','sh_person_primary_network','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('person_to_role','sh_person_to_role','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('profile_component','sh_profile_component','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('profile_component_visibility','sh_profile_component_visibilit','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('profile_visibility_for_role','sh_profile_visibility_for_role','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('random_member_component_cfg','sh_random_member_component_cfg','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('raweditor_version','sh_raweditor_version','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('rights','sh_rights','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('school','sh_school','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('start_page_profile','sh_start_page_profile','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('survey','sh_survey','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('survey_participant_answer','sh_survey_participant_answer','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('survey_predefined_answer','sh_survey_predefined_answer','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('survey_question','sh_survey_question','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('university','sh_university','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('user_setting','sh_user_setting','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('wiki_editor','sh_wiki_editor','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('wiki_editor_backup','sh_wiki_editor_backup','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('wiki_editor_version','sh_wiki_editor_version','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('workstream','sh_workstream','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('workstream_attachment','sh_workstream_attachment','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('workstream_entry','sh_workstream_entry','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('workstream_entry_attribute','sh_workstream_entry_attribute','f');


COMMIT;