BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01299, '6.12', 'migrate-component-type', 'FEATURE', 'child entities component types have parameter now', now());

CREATE TABLE temp_component_type (
    old_name VARCHAR(255) NOT NULL PRIMARY KEY,
    new_name VARCHAR(255) NOT NULL
);

INSERT INTO temp_component_type(old_name, new_name) VALUES
('CHILD_APPOINTMENTS', 'CHILD_ENTITIES#APPOINTMENT'),
('CHILD_GROUPS', 'CHILD_ENTITIES#GROUP'),
('CHILD_NETWORKS', 'CHILD_ENTITIES#NETWORK'),
('CHILD_PUBLICATIONS', 'CHILD_ENTITIES#PUBLICATION'),
('CHILD_WIKIS', 'CHILD_ENTITIES#WIKI'),
('CHILD_TOPICS', 'CHILD_ENTITIES#TOPIC'),
('CHILD_ARTICLES', 'CHILD_ENTITIES#ARTICLE'),
('CHILD_PARTNERSITES', 'CHILD_ENTITIES#PARTNERSITE');

ALTER TABLE entity_component ALTER COLUMN component_type TYPE VARCHAR(255);
UPDATE entity_component
    SET component_type = (SELECT new_name FROM temp_component_type WHERE old_name = component_type)
    WHERE component_type IN (SELECT old_name FROM temp_component_type);

ALTER TABLE entity_component_open_for ALTER COLUMN component_type TYPE VARCHAR(255);
UPDATE entity_component_open_for
    SET component_type = (SELECT new_name FROM temp_component_type
    WHERE old_name = component_type) WHERE component_type IN (SELECT old_name FROM temp_component_type);

ALTER TABLE profile_component ALTER COLUMN component_type TYPE VARCHAR(255);
UPDATE profile_component 
    SET component_type = (SELECT new_name FROM temp_component_type WHERE old_name = component_type)
    WHERE component_type IN (SELECT old_name FROM temp_component_type);

ALTER TABLE profile_component_visibility ALTER COLUMN component_type TYPE VARCHAR(255);
UPDATE profile_component_visibility
    SET component_type = (SELECT new_name FROM temp_component_type WHERE old_name = component_type)
    WHERE component_type IN (SELECT old_name FROM temp_component_type);

ALTER TABLE raweditor_version ALTER COLUMN editor_type TYPE VARCHAR(255);
UPDATE raweditor_version
    SET editor_type = (SELECT new_name FROM temp_component_type WHERE old_name = editor_type)
    WHERE editor_type IN (SELECT old_name FROM temp_component_type);

DROP TABLE temp_component_type;

COMMIT;
