BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01240, '6.5', 'migrate-old-subscriptions', 'FEATURE', '#2516 Migration Subscription -> Abo/Like', now());

-- Subscriptions of an module -> Subscription and like of the whole entity ---

INSERT INTO "like" (liker_id, item_id, item_type)
          SELECT subscriber_id, entity_id, 'ENTITY'
      FROM subscription
      WHERE subscription_type = 'componentType'
          GROUP BY subscriber_id, entity_id;

INSERT INTO like_subscribe (subscriber_id, item_id, item_type)
          SELECT subscriber_id, entity_id, 'ENTITY'
      FROM subscription
      WHERE subscription_type = 'componentType'
          GROUP BY subscriber_id, entity_id;

-- Subscriptions of an item -> Subscription of an item ------------------------

INSERT INTO like_subscribe (subscriber_id, item_id, item_type)
          SELECT subscriber_id, item_id, item_type
      FROM subscription
          WHERE subscription_type = 'item'
            AND item_id IS NOT NULL
    AND item_type IS NOT NULL;

COMMIT;
