/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.structure.sequence.impl;

import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.structure.sequence.SequenceUpdater;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

public class DefaultSequenceUpdater
implements SequenceUpdater {
    private static Log logger = LogFactory.getLog(DefaultSequenceUpdater.class);
    protected long lowestAcceptableSequenceValue;
    protected Databases databases;

    public DefaultSequenceUpdater(long lowestAcceptableSequenceValue, Databases databases) {
        this.lowestAcceptableSequenceValue = lowestAcceptableSequenceValue;
        this.databases = databases;
    }

    public void updateSequences() {
        for (Database database : this.databases.getDatabases()) {
            for (String schemaName : database.getSchemaNames()) {
                logger.info("Updating sequences and identity columns in database " + (database.getDatabaseName() != null ? database.getDatabaseName() + ", and schema " : "schema ") + schemaName);
                this.incrementSequencesWithLowValue(database, schemaName);
                this.incrementIdentityColumnsWithLowValue(database, schemaName);
            }
        }
    }

    private void incrementSequencesWithLowValue(Database database, String schemaName) {
        if (!database.supportsSequences()) {
            return;
        }
        Set<String> sequenceNames = database.getSequenceNames(schemaName);
        for (String sequenceName : sequenceNames) {
            if (database.getSequenceValue(schemaName, sequenceName) >= this.lowestAcceptableSequenceValue) continue;
            logger.debug("Incrementing value for sequence " + sequenceName + " in database schema " + schemaName);
            database.incrementSequenceToValue(schemaName, sequenceName, this.lowestAcceptableSequenceValue);
        }
    }

    private void incrementIdentityColumnsWithLowValue(Database database, String schemaName) {
        if (!database.supportsIdentityColumns()) {
            return;
        }
        Set<String> tableNames = database.getTableNames(schemaName);
        for (String tableName : tableNames) {
            Set<String> identityColumnNames = database.getIdentityColumnNames(schemaName, tableName);
            for (String identityColumnName : identityColumnNames) {
                try {
                    database.incrementIdentityColumnToValue(schemaName, tableName, identityColumnName, this.lowestAcceptableSequenceValue);
                    logger.debug("Incrementing value for identity column " + identityColumnName + " in database schema " + schemaName);
                }
                catch (DbMaintainException e) {}
            }
        }
    }
}

