/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.qualifier.QualifierEvaluator;
import org.dbmaintain.script.repository.ScriptLocation;
import org.dbmaintain.util.DbMaintainException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRepository {
    protected SortedSet<Script> indexedScripts = new TreeSet<Script>();
    protected SortedSet<Script> repeatableScripts = new TreeSet<Script>();
    protected SortedSet<Script> postProcessingScripts = new TreeSet<Script>();
    protected QualifierEvaluator qualifierEvaluator;

    public ScriptRepository(Set<ScriptLocation> scriptLocations, QualifierEvaluator qualifierEvaluator) {
        this.qualifierEvaluator = qualifierEvaluator;
        this.initScripts(scriptLocations);
    }

    public boolean areScriptsAvailable() {
        return this.indexedScripts.size() > 0 || this.repeatableScripts.size() > 0 || this.postProcessingScripts.size() > 0;
    }

    public SortedSet<Script> getIndexedScripts() {
        return this.indexedScripts;
    }

    public SortedSet<Script> getRepeatableScripts() {
        return this.repeatableScripts;
    }

    public SortedSet<Script> getAllUpdateScripts() {
        TreeSet<Script> allUpdateScripts = new TreeSet<Script>();
        allUpdateScripts.addAll(this.indexedScripts);
        allUpdateScripts.addAll(this.repeatableScripts);
        return allUpdateScripts;
    }

    public SortedSet<Script> getPostProcessingScripts() {
        return this.postProcessingScripts;
    }

    public SortedSet<Script> getAllScripts() {
        TreeSet<Script> allScripts = new TreeSet<Script>();
        allScripts.addAll(this.indexedScripts);
        allScripts.addAll(this.repeatableScripts);
        allScripts.addAll(this.postProcessingScripts);
        return allScripts;
    }

    protected void initScripts(Set<ScriptLocation> scriptLocations) {
        this.assertNoDuplicateScripts(scriptLocations);
        for (ScriptLocation scriptLocation : scriptLocations) {
            for (Script script : scriptLocation.getScripts()) {
                if (!this.qualifierEvaluator.evaluate(script.getQualifiers())) continue;
                this.initScript(script);
            }
        }
        this.assertNoDuplicateScriptIndexes();
    }

    private void initScript(Script script) {
        if (script.isPostProcessingScript()) {
            this.postProcessingScripts.add(script);
        } else if (script.isIncremental()) {
            if (!script.isIgnored()) {
                this.indexedScripts.add(script);
            }
        } else {
            this.repeatableScripts.add(script);
        }
    }

    protected void assertNoDuplicateScriptIndexes() {
        Script current = null;
        for (Script script : this.indexedScripts) {
            Script previous = current;
            current = script;
            if (previous == null || !previous.getScriptIndexes().equals(current.getScriptIndexes())) continue;
            throw new DbMaintainException("Found 2 indexed scripts with the same index: " + previous.getFileName() + " and " + current.getFileName() + ": both scripts have index " + previous.getScriptIndexes().getIndexesString());
        }
    }

    protected void assertNoDuplicateScripts(Set<ScriptLocation> scriptLocations) {
        HashSet<DuplicateScript> duplicateScripts = new HashSet<DuplicateScript>();
        ArrayList<ScriptLocation> scriptLocationList = new ArrayList<ScriptLocation>(scriptLocations);
        for (int i = 0; i < scriptLocationList.size() - 1; ++i) {
            for (Script script : ((ScriptLocation)scriptLocationList.get(i)).getScripts()) {
                for (int j = i + 1; j < scriptLocationList.size(); ++j) {
                    if (!((ScriptLocation)scriptLocationList.get(j)).getScripts().contains(script)) continue;
                    duplicateScripts.add(new DuplicateScript(script, (ScriptLocation)scriptLocationList.get(i), (ScriptLocation)scriptLocationList.get(j)));
                }
            }
        }
        if (duplicateScripts.size() > 0) {
            StringBuilder message = new StringBuilder("Duplicate scripts found:\n");
            for (DuplicateScript duplicateScript : duplicateScripts) {
                message.append("- ").append(duplicateScript.getDuplicateScript().getFileName()).append(" at ").append(duplicateScript.getLocation1().getLocationName()).append(" and ").append(duplicateScript.getLocation2().getLocationName()).append("\n");
            }
            throw new DbMaintainException(message.toString());
        }
    }

    private static class DuplicateScript {
        private Script duplicateScript;
        private ScriptLocation location1;
        private ScriptLocation location2;

        public DuplicateScript(Script duplicateScript, ScriptLocation location1, ScriptLocation location2) {
            this.duplicateScript = duplicateScript;
            this.location1 = location1;
            this.location2 = location2;
        }

        public Script getDuplicateScript() {
            return this.duplicateScript;
        }

        public ScriptLocation getLocation1() {
            return this.location1;
        }

        public ScriptLocation getLocation2() {
            return this.location2;
        }
    }
}

