/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script;

import java.util.Set;
import org.dbmaintain.script.ScriptContentHandle;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.qualifier.Qualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Script
implements Comparable<Script> {
    private String fileName;
    private ScriptIndexes scriptIndexes;
    private String targetDatabaseName;
    private Long fileLastModifiedAt;
    private String checkSum;
    private ScriptContentHandle scriptContentHandle;
    private boolean postProcessingScript;
    private boolean patchScript;
    private boolean ignored;
    private Set<Qualifier> qualifiers;

    public Script(String fileName, ScriptIndexes scriptIndexes, String targetDatabaseName, Long fileLastModifiedAt, String checkSum, ScriptContentHandle scriptContentHandle, boolean postProcessingScript, boolean patchScript, boolean ignored, Set<Qualifier> qualifiers) {
        this.fileName = fileName;
        this.scriptIndexes = scriptIndexes;
        this.targetDatabaseName = targetDatabaseName;
        this.fileLastModifiedAt = fileLastModifiedAt;
        this.checkSum = checkSum;
        this.scriptContentHandle = scriptContentHandle;
        this.postProcessingScript = postProcessingScript;
        this.patchScript = patchScript;
        this.ignored = ignored;
        this.qualifiers = qualifiers;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameWithoutPath() {
        int index = this.fileName.lastIndexOf(92);
        if (index == -1) {
            index = this.fileName.lastIndexOf(47);
        }
        if (index == -1) {
            return this.fileName;
        }
        return this.fileName.substring(index + 1);
    }

    public ScriptIndexes getScriptIndexes() {
        return this.scriptIndexes;
    }

    public String getTargetDatabaseName() {
        return this.targetDatabaseName;
    }

    public Long getFileLastModifiedAt() {
        return this.fileLastModifiedAt;
    }

    public String getCheckSum() {
        if (this.checkSum == null) {
            this.checkSum = this.scriptContentHandle.getCheckSum();
        }
        return this.checkSum;
    }

    public ScriptContentHandle getScriptContentHandle() {
        return this.scriptContentHandle;
    }

    public boolean isScriptContentEqualTo(Script other, boolean useLastModificationDates) {
        return useLastModificationDates && this.getFileLastModifiedAt().equals(other.getFileLastModifiedAt()) || this.getCheckSum().equals(other.getCheckSum());
    }

    public boolean isIncremental() {
        return !this.isPostProcessingScript() && this.scriptIndexes.isIncrementalScript();
    }

    public boolean isRepeatable() {
        return !this.isPostProcessingScript() && this.scriptIndexes.isRepeatableScript();
    }

    public boolean isPostProcessingScript() {
        return this.postProcessingScript;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public boolean isPatchScript() {
        return this.patchScript;
    }

    public Set<Qualifier> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public int compareTo(Script script) {
        if (!this.isPostProcessingScript() && script.isPostProcessingScript()) {
            return -1;
        }
        if (this.isPostProcessingScript() && !script.isPostProcessingScript()) {
            return 1;
        }
        int versionComparison = this.scriptIndexes.compareTo(script.getScriptIndexes());
        if (versionComparison != 0) {
            return versionComparison;
        }
        return this.fileName.compareTo(script.fileName);
    }

    public int hashCode() {
        return 31 + (this.fileName == null ? 0 : this.fileName.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Script other = (Script)object;
        return !(this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName));
    }

    public String toString() {
        return this.fileName;
    }
}

