/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database;

import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.StoredIdentifierCase;

public class IdentifierProcessor {
    protected StoredIdentifierCase storedIdentifierCase;
    protected String identifierQuoteString;
    protected String defaultSchemaName;

    public IdentifierProcessor(StoredIdentifierCase storedIdentifierCase, String identifierQuoteString, String defaultSchemaName) {
        this.storedIdentifierCase = storedIdentifierCase;
        this.identifierQuoteString = identifierQuoteString;
        this.defaultSchemaName = this.toCorrectCaseIdentifier(defaultSchemaName);
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public String quoted(String databaseObjectName) {
        if (this.identifierQuoteString == null) {
            return databaseObjectName;
        }
        return this.identifierQuoteString + databaseObjectName + this.identifierQuoteString;
    }

    public boolean isQuoted(String identifier) {
        if (this.identifierQuoteString == null) {
            return false;
        }
        return identifier.startsWith(this.identifierQuoteString) && identifier.endsWith(this.identifierQuoteString);
    }

    public String removeIdentifierQuotes(String identifier) {
        if (this.identifierQuoteString == null) {
            return identifier;
        }
        if (identifier.startsWith(this.identifierQuoteString) && identifier.endsWith(this.identifierQuoteString)) {
            return identifier.substring(1, identifier.length() - 1);
        }
        return identifier;
    }

    public String qualified(String databaseObjectName) {
        return this.qualified(this.defaultSchemaName, databaseObjectName);
    }

    public String qualified(String schemaName, String databaseObjectName) {
        return this.quoted(schemaName) + "." + this.quoted(databaseObjectName);
    }

    public String toCorrectCaseIdentifier(String identifier) {
        int index = (identifier = identifier.trim()).indexOf(46);
        if (index != -1) {
            String schemaNamePart = identifier.substring(0, index);
            String identifierPart = identifier.substring(index + 1);
            return this.toCorrectCaseIdentifier(schemaNamePart) + "." + this.toCorrectCaseIdentifier(identifierPart);
        }
        if (this.isQuoted(identifier)) {
            return this.removeIdentifierQuotes(identifier);
        }
        if (this.storedIdentifierCase == StoredIdentifierCase.UPPER_CASE) {
            return identifier.toUpperCase();
        }
        if (this.storedIdentifierCase == StoredIdentifierCase.LOWER_CASE) {
            return identifier.toLowerCase();
        }
        return identifier;
    }

    public String getSchemaName(String qualifiedTableName) {
        int index = qualifiedTableName.indexOf(46);
        if (index == -1) {
            throw new DatabaseException("Unable to determine schema name for qualified table name " + qualifiedTableName);
        }
        String schemaName = qualifiedTableName.substring(0, index);
        return this.removeIdentifierQuotes(schemaName);
    }

    public String getTableName(String qualifiedTableName) {
        int index = qualifiedTableName.indexOf(46);
        if (index == -1) {
            throw new DatabaseException("Unable to determine table name for qualified table name " + qualifiedTableName);
        }
        String tableName = qualifiedTableName.substring(index + 1);
        return this.removeIdentifierQuotes(tableName);
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public StoredIdentifierCase getStoredIdentifierCase() {
        return this.storedIdentifierCase;
    }
}

