/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.dbmaintain.config.PropertyUtils;
import org.dbmaintain.database.DatabaseInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseInfoFactory {
    protected Properties configuration;

    public DatabaseInfoFactory(Properties configuration) {
        this.configuration = configuration;
    }

    public List<DatabaseInfo> createDatabaseInfos() {
        ArrayList<DatabaseInfo> databaseInfos = new ArrayList<DatabaseInfo>();
        List<String> databaseNames = PropertyUtils.getStringList("databases.names", this.configuration);
        if (databaseNames.isEmpty()) {
            databaseInfos.add(this.getUnnamedDatabaseInfo());
            return databaseInfos;
        }
        boolean defaultDatabase = true;
        for (String databaseName : databaseNames) {
            boolean disabled = !this.isDatabaseIncluded(databaseName);
            DatabaseInfo databaseInfo = this.createDatabaseInfo(databaseName, disabled, defaultDatabase);
            databaseInfos.add(databaseInfo);
            defaultDatabase = false;
        }
        return databaseInfos;
    }

    protected DatabaseInfo getUnnamedDatabaseInfo() {
        String driverClassName = this.getProperty(null, "driverClassName");
        String url = this.getProperty(null, "url");
        String userName = this.getProperty(null, "userName");
        String password = this.getProperty(null, "password");
        String databaseDialect = this.getProperty(null, "dialect");
        List<String> schemaNames = this.getListProperty(null, "schemaNames");
        return new DatabaseInfo(null, databaseDialect, driverClassName, url, userName, password, schemaNames, false, true);
    }

    protected DatabaseInfo createDatabaseInfo(String databaseName, boolean disabled, boolean defaultDatabase) {
        String driverClassName = this.getProperty(databaseName, "driverClassName");
        String url = this.getProperty(databaseName, "url");
        String userName = this.getProperty(databaseName, "userName");
        String password = this.getProperty(databaseName, "password");
        String databaseDialect = this.getProperty(databaseName, "dialect");
        List<String> schemaNames = this.getListProperty(databaseName, "schemaNames");
        return new DatabaseInfo(databaseName, databaseDialect, driverClassName, url, userName, password, schemaNames, disabled, defaultDatabase);
    }

    protected boolean isDatabaseIncluded(String databaseName) {
        return PropertyUtils.getBoolean("database." + databaseName + '.' + "included", true, this.configuration);
    }

    protected String getProperty(String databaseName, String propertyNameEnd) {
        String customPropertyName;
        if (databaseName != null && PropertyUtils.containsProperty(customPropertyName = "database." + databaseName + '.' + propertyNameEnd, this.configuration)) {
            return PropertyUtils.getString(customPropertyName, null, this.configuration);
        }
        String defaultPropertyName = "database." + propertyNameEnd;
        return PropertyUtils.getString(defaultPropertyName, null, this.configuration);
    }

    protected List<String> getListProperty(String databaseName, String propertyNameEnd) {
        String customPropertyName;
        if (databaseName != null && PropertyUtils.containsProperty(customPropertyName = "database." + databaseName + '.' + propertyNameEnd, this.configuration)) {
            return PropertyUtils.getStringList(customPropertyName, this.configuration, false);
        }
        String defaultPropertyName = "database." + propertyNameEnd;
        return PropertyUtils.getStringList(defaultPropertyName, this.configuration, false);
    }
}

